% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supported_currencies.R
\name{supported_currencies}
\alias{supported_currencies}
\title{CoinGecko currencies}
\usage{
supported_currencies(max_attempts = 3)
}
\arguments{
\item{max_attempts}{(double, positive): specifies the
maximum number of attempts to call the CoinGecko API (e.g., if
the first call fails for some reason). Additional attempts are
implemented with an exponential backoff. Defaults to 3.}
}
\value{
Character vector with abbreviated names of the currencies.
}
\description{
Retrieves a list of base currencies currently supported by the CoinGecko API
}
\details{
This function is based on the public
\href{https://www.coingecko.com/api/documentations/v3}{CoinGecko API},
which has a limit of 50 calls per minute. Please
keep this limit in mind when developing your applications.
}
\examples{
\donttest{
r <- supported_currencies()
print(r)
}
}
