% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{bootcurve}
\alias{bootcurve}
\title{Plot Fitted Curves and Corresponding Confidence Interval using
bootstrapping method}
\usage{
bootcurve(object, nboot)
}
\arguments{
\item{object}{a fitted joint mean covariance model of class "geerMod", i.e.,
typically the result of geer().}

\item{nboot}{number of the bootstrap replications.}
}
\description{
Plot fitted curves and corresponding 95\% confidence interval
using bootstrapping method.
}
\examples{
\dontrun{
# It may take hours for large bootstrap replications
fitgee.ar1 <- geer(cd4|id|time ~ 1|1, data = aids, triple = c(6,3,3),
  method = 'gee-mcd', corr.struct = 'ar1', rho = 0.5,
  control = geerControl(trace=TRUE))
bootcurve(fitgee.ar1, nboot = 1000)
}

}
