% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{gees_estimation}
\alias{gees_estimation}
\title{Fit (Weighted) Generalized Estimating Equations based on MCD}
\usage{
gees_estimation(m, Y, X, Z, W, H, method, corrStruct, rho, start,
  trace = FALSE, profile = TRUE, errorMsg = FALSE)
}
\arguments{
\item{m}{an integer vector of number of measurements for each subject.}

\item{Y}{a vector of responses for all subjects.}

\item{X}{model matrix for mean structure model.}

\item{Z}{model matrix for the diagonal matrix.}

\item{W}{model matrix for the lower triangular matrix.}

\item{H}{a vector of weights used in WGEE-MCD.}

\item{method}{choose 'gee-mcd' (Ye and Pan, 2006) or 'wgee-mcd' (Pan et al. 2012).}

\item{corrStruct}{choose 'id' (independent), 'cs' (compound symmetry) or ar1' (AR(1)).}

\item{rho}{a parameter used in the 'working' covariance structure.}

\item{start}{starting values for the parameters in the model.}

\item{trace}{the values of the objective function and the parameters are
printed for all the trace'th iterations.}

\item{profile}{whether parameters should be estimated sequentially using the
idea of profile likelihood or not.}

\item{errorMsg}{whether or not the error message should be print.}
}
\description{
Fit (weighted) generalized estimating equations based on MCD.
}
