% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_funs.R
\name{estimate_GFUN_roots}
\alias{estimate_GFUN_roots}
\title{Estimate roots for a set of estimating equations}
\usage{
estimate_GFUN_roots(.basis)
}
\arguments{
\item{.basis}{an object of class \code{\linkS4class{m_estimation_basis}}}
}
\value{
the output of the \code{rootFUN} function
}
\description{
Using the \code{rootFUN} specified by the user (defaults to \code{\link[rootSolve]{multiroot}}),
this function estimates the roots of the equations:
\deqn{G_m = sum_i psi(O_i, \hat{\theta}) = 0}{G_m = sum_i psi(O_i, theta) = 0}
}
\details{
This is primilary an internal function used within \code{\link{m_estimate}},
but it is exported for use in debugging and development.

For an example of how to use a different \code{rootFUN},
see the root solver vignette, \code{vignette('geex_root_solvers', package = 'geex')}.
}
\examples{

myee <- function(data){
  function(theta){
    c(data$Y1 - theta[1],
     (data$Y1 - theta[1])^2 - theta[2])
   }
 }

# Start with a basic basis
mybasis <- create_basis(
  estFUN = myee,
  data   = geexex)

# Add a control for the root solver
mycontrol <- new('geex_control', .root = setup_root_control(start = c(1, 1)))
mybasis@.control <- mycontrol

# Now estimate roots of GFUN
roots <- estimate_GFUN_roots(mybasis)
roots

}
