% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correct_by_funs.R
\name{fay_df_correction}
\alias{fay_df_correction}
\title{Correct sandwich variance inference by Fay's degrees of freedom correction}
\usage{
fay_df_correction(components, b = 0.75, L, version)
}
\arguments{
\item{components}{an object of class \code{\linkS4class{sandwich_components}}}

\item{b}{a numeric value < 1. Defaults to 0.75 as in Fay.}

\item{L}{a k x p matrix where p is the dimension of theta}

\item{version}{either 1 or 2, corresponding to hat(d) or tilde(d), respectively}
}
\value{
a scalar corresponding to the estimated degrees of freedom
}
\description{
Computes the degrees of freedom correction described in Fay and
Graubard (2001). See \code{vignette("05_finite_sample_corrections", package = "geex")}
for further information.
}
\examples{

# This example demonstrates usage of the corrections, not a meaningful application
myee <- function(data){
 function(theta){
   c(data$Y1 - theta[1],
   (data$Y1 - theta[1])^2 - theta[2])
  }
}

results <- m_estimate(
   estFUN = myee,
   data = geexex,
   root_control = setup_root_control(start = c(1,1)),
   corrections  = list(
     df_correction1 = correction(fay_df_correction,
                        b = .75, L = c(0, 1), version = 1 ),
     df_correction2 = correction(fay_df_correction,
                        b = .75, L = c(0, 1), version = 2 ))
   )

get_corrections(results)
}
\references{
Fay, M. P., & Graubard, B. I. (2001). Small-Sample adjustments for
Wald-type tests using sandwich estimators. Biometrics, 57(4), 1198-1206
}
