% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.krr}
\alias{gelnet.krr}
\title{Kernel ridge regression}
\usage{
gelnet.krr(K, y, a, lambda, fix.bias = FALSE)
}
\arguments{
\item{K}{n-by-n matrix of pairwise kernel values over a set of n samples}

\item{y}{n-by-1 vector of response values}

\item{a}{n-by-1 vector of samples weights}

\item{lambda}{scalar, regularization parameter}

\item{fix.bias}{set to TRUE to force the bias term to 0 (default: FALSE)}
}
\value{
A list with two elements:
\describe{
  \item{v}{n-by-1 vector of kernel weights}
  \item{b}{scalar, bias term for the model}
}
}
\description{
Learns a kernel ridge regression model.
}
\details{
The entries in the kernel matrix K can be interpreted as dot products
in some feature space \eqn{\phi}. The corresponding weight vector can be
retrieved via \eqn{w = \sum_i v_i \phi(x_i)}. However, new samples can be
classified without explicit access to the underlying feature space:
\deqn{w^T \phi(x) + b = \sum_i v_i \phi^T (x_i) \phi(x) + b = \sum_i v_i K( x_i, x ) + b}
}
\seealso{
\code{\link{gelnet.lin}}
}

