/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.JumpPerturber;
import java.text.NumberFormat;
import java.util.Random;

public class SingleZeroToPositivePerturber
implements JumpPerturber {
    private String stringvalue = "";
    private NumberFormat nf;
    private final int which;
    private final int whichpoint;
    private double mien = 1.0;
    private double scale = 1.0;
    private double adj = 1.0;
    static Random rand = new Random(System.currentTimeMillis());

    public SingleZeroToPositivePerturber(int which, int whichpoint, double mien) {
        this.which = which;
        this.whichpoint = whichpoint;
        this.mien = mien;
        this.nf = NumberFormat.getNumberInstance();
        this.nf.setMaximumFractionDigits(3);
        this.nf.setGroupingUsed(false);
    }

    public void perturb(double[][] candarray, int whoseTurn) {
        double temp = rand.nextDouble();
        whoseTurn = this.whichpoint;
        this.scale = temp = -this.mien * Math.log(temp);
        candarray[this.which][whoseTurn] = temp;
        this.stringvalue = this.nf.format(candarray[this.which][whoseTurn]) + "";
    }

    public int numTurns() {
        return 1;
    }

    public double jacobian() {
        return this.adj;
    }

    public double density(double[][] oldarr, double[][] newarr, int whoseTurn) {
        whoseTurn = this.whichpoint;
        return Math.exp(-newarr[this.which][this.whichpoint] / this.mien) / this.mien;
    }

    public String toString() {
        return this.stringvalue;
    }
}

