/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.summary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.mtc.MCMCResults;
import org.drugis.mtc.MCMCResultsEvent;
import org.drugis.mtc.MCMCResultsListener;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.BasicParameter;
import org.drugis.mtc.summary.RankCounter;
import org.drugis.mtc.summary.Summary;
import org.drugis.mtc.summary.SummaryUtil;

public class RankProbabilitySummary
extends AbstractObservable
implements MCMCResultsListener,
Summary {
    public static final String PROPERTY_VALUE = "value";
    private List<Treatment> d_treatments;
    private MCMCResults d_results;
    private int d_n;
    private double[][] d_rankProbability;
    private boolean d_ready = false;

    public RankProbabilitySummary(MCMCResults results, List<Treatment> treatments) {
        this.d_results = results;
        this.d_results.addResultsListener(this);
        this.d_treatments = treatments;
        this.d_n = treatments.size();
        this.calculate();
    }

    public RankProbabilitySummary(double[][] rankProbabilityMatrix, List<Treatment> treatments) {
        this.d_rankProbability = rankProbabilityMatrix;
        this.d_treatments = treatments;
        this.d_n = treatments.size();
        this.d_ready = true;
    }

    @Override
    public void resultsEvent(MCMCResultsEvent event) {
        this.calculate();
        this.firePropertyChange("defined", null, this.getDefined());
        this.firePropertyChange(PROPERTY_VALUE, null, this);
    }

    public List<Treatment> getTreatments() {
        return Collections.unmodifiableList(this.d_treatments);
    }

    public double getValue(Treatment t, int rank) {
        if (!this.d_ready) {
            return 0.0;
        }
        int rIdx = this.d_n - rank;
        int tIdx = this.d_treatments.indexOf(t);
        return this.d_rankProbability[tIdx][rIdx];
    }

    private synchronized void calculate() {
        int i;
        boolean bl = this.d_ready = this.d_results.getNumberOfSamples() > 0;
        if (!this.d_ready) {
            return;
        }
        Treatment base = this.d_treatments.get(0);
        ArrayList<List<Double>> samples = new ArrayList<List<Double>>();
        for (int i2 = 1; i2 < this.d_n; ++i2) {
            samples.add(SummaryUtil.getAllChainsLastHalfSamples(this.d_results, new BasicParameter(base, this.d_treatments.get(i2))));
        }
        int[][] rankCount = new int[this.d_n][this.d_n];
        int nSamples = ((List)samples.get(0)).size();
        for (i = 0; i < nSamples; ++i) {
            double[] data = new double[this.d_n];
            for (int j = 1; j < this.d_n; ++j) {
                data[j] = (Double)((List)samples.get(j - 1)).get(i);
            }
            int[] ranks = RankCounter.rank(data);
            for (int j = 0; j < this.d_n; ++j) {
                int[] nArray = rankCount[j];
                int n = ranks[j] - 1;
                nArray[n] = nArray[n] + 1;
            }
        }
        this.d_rankProbability = new double[this.d_n][this.d_n];
        for (i = 0; i < this.d_n; ++i) {
            for (int j = 0; j < this.d_n; ++j) {
                this.d_rankProbability[i][j] = (double)rankCount[i][j] / (double)nSamples;
            }
        }
    }

    @Override
    public boolean getDefined() {
        return this.d_ready;
    }
}

