/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.yadas;

import edu.uci.ics.jung.graph.util.Pair;
import gov.lanl.yadas.ArgumentMaker;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.drugis.mtc.model.Study;
import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.Parameterization;

public class RelativeEffectArgumentMaker
implements ArgumentMaker {
    List<Pair<Treatment>> d_delta;
    private final Parameterization d_pmtz;
    private RealMatrix d_matrix;
    private final int d_bIdx;
    private final int d_wIdx;

    public RelativeEffectArgumentMaker(Parameterization pmtz, Study study, int bIdx, int wIdx) {
        this.d_pmtz = pmtz;
        this.d_bIdx = bIdx;
        this.d_wIdx = wIdx;
        this.d_delta = new ArrayList<Pair<Treatment>>(study.getTreatments().size() - 1);
        for (List<Pair<Treatment>> list : pmtz.parameterizeStudy(study)) {
            this.d_delta.addAll(list);
        }
        this.initializeMatrix();
    }

    private void initializeMatrix() {
        List<NetworkParameter> params = this.d_pmtz.getParameters();
        this.d_matrix = new Array2DRowRealMatrix(this.d_delta.size(), params.size());
        for (int i = 0; i < this.d_delta.size(); ++i) {
            Map<NetworkParameter, Integer> map = this.d_pmtz.parameterize(this.d_delta.get(i).getFirst(), this.d_delta.get(i).getSecond());
            for (int j = 0; j < params.size(); ++j) {
                Integer val = map.get(params.get(j));
                if (val == null) continue;
                this.d_matrix.setEntry(i, j, val.intValue());
            }
        }
    }

    @Override
    public double[] getArgument(double[][] data) {
        double[] x = data[this.d_bIdx];
        if (this.d_wIdx >= 0) {
            x = new double[data[this.d_bIdx].length + data[this.d_wIdx].length];
            System.arraycopy(data[this.d_bIdx], 0, x, 0, data[this.d_bIdx].length);
            System.arraycopy(data[this.d_wIdx], 0, x, data[this.d_bIdx].length, data[this.d_wIdx].length);
        }
        return this.d_matrix.operate(x);
    }
}

