/*
 * Decompiled with CFR 0.152.
 */
package gov.lanl.yadas;

import gov.lanl.yadas.Likelihood;
import gov.lanl.yadas.Tools;

public class SeveralDirichlets
implements Likelihood {
    private int[] labels;
    private int N;
    private int[][] labelmat;
    double minn = 1.0;

    public SeveralDirichlets(int[] labels) {
        this.labels = labels;
        this.N = 1 + SeveralDirichlets.max(labels);
        this.labelmat = new int[this.N][];
        for (int i = 0; i < this.N; ++i) {
            int j;
            int ct = 0;
            for (j = 0; j < labels.length; ++j) {
                if (labels[j] != i) continue;
                ++ct;
            }
            this.labelmat[i] = new int[ct];
            for (j = 0; j < labels.length; ++j) {
                if (labels[j] != i) continue;
                this.labelmat[i][this.labelmat[i].length - ct--] = j;
            }
        }
    }

    public double compute(double[][] args) {
        double[] probs = args[0];
        double[] exponents = args[1];
        double out = 0.0;
        for (int n = 0; n < this.N; ++n) {
            int i;
            double sumnu = 0.0;
            for (i = 0; i < this.labelmat[n].length; ++i) {
                sumnu += exponents[this.labelmat[n][i]];
            }
            out += Tools.loggamma(sumnu);
            for (i = 0; i < this.labelmat[n].length; ++i) {
                int ii = this.labelmat[n][i];
                out -= Tools.loggamma(exponents[ii]);
                if (!(exponents[ii] > 0.0)) continue;
                out += (exponents[ii] - 1.0) * Math.log(probs[ii]);
            }
        }
        return out;
    }

    public static double[] rep(double r, int n) {
        double[] out = new double[n];
        for (int i = 0; i < n; ++i) {
            out[i] = r;
        }
        return out;
    }

    public static int max(int[] vec) {
        int out = vec[0];
        for (int i = 1; i < vec.length; ++i) {
            out = Math.max(out, vec[i]);
        }
        return out;
    }

    public static void main(String[] args) {
    }
}

