/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.graph;

import edu.uci.ics.jung.algorithms.shortestpath.DijkstraShortestPath;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.drugis.mtc.graph.PointOnEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbsoluteOneCenter<V, E> {
    private final UndirectedGraph<V, E> d_graph;
    private final Distance<V> d_distance;
    private final Transformer<E, Number> d_edgeLength;
    private Comparator<V> d_comparator;

    public AbsoluteOneCenter(UndirectedGraph<V, E> graph) {
        this(graph, new UnitLength(), new DijkstraShortestPath<V, E>(graph));
    }

    public AbsoluteOneCenter(UndirectedGraph<V, E> graph, Comparator<V> comparator) {
        this(graph, new UnitLength(), new DijkstraShortestPath<V, E>(graph), comparator);
    }

    public AbsoluteOneCenter(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength) {
        this(graph, edgeLength, new DijkstraShortestPath<V, E>(graph));
    }

    public AbsoluteOneCenter(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Comparator<V> comparator) {
        this(graph, edgeLength, new DijkstraShortestPath<V, E>(graph), comparator);
    }

    public AbsoluteOneCenter(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Distance<V> distance) {
        this(graph, edgeLength, distance, null);
    }

    public AbsoluteOneCenter(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Distance<V> distance, Comparator<V> comparator) {
        this.d_graph = graph;
        this.d_edgeLength = edgeLength;
        this.d_distance = distance;
        this.d_comparator = comparator;
    }

    public PointOnEdge<V, E> getCenter() {
        LocalCenter<V, E> localCenter = new LocalCenter<V, E>(this.d_graph, this.d_edgeLength, this.d_distance, this.d_comparator);
        Object c = null;
        for (Object e : this.d_graph.getEdges()) {
            Object lc = localCenter.transform(e);
            if (c != null && !(((Center)lc).getRadius() < ((Center)c).getRadius()) && (((Center)lc).getRadius() != ((Center)c).getRadius() || this.compareEdge(((PointOnEdge)lc).getEdge(), ((PointOnEdge)c).getEdge()) >= 0)) continue;
            c = lc;
        }
        return c;
    }

    private int compareEdge(E e1, E e2) {
        if (this.d_comparator == null) {
            return 0;
        }
        Pair x = new Pair(this.d_graph.getIncidentVertices(e1));
        Pair y = new Pair(this.d_graph.getIncidentVertices(e2));
        int compareFirst = this.d_comparator.compare(x.getFirst(), y.getFirst());
        if (compareFirst != 0) {
            return compareFirst;
        }
        return this.d_comparator.compare(x.getSecond(), y.getSecond());
    }

    static <V> Double intersect(Distance<V> distance, V e0, V e1, double l, V u, V v) {
        double lu = distance.getDistance(e0, u).doubleValue();
        double ru = distance.getDistance(e1, u).doubleValue();
        double lv = distance.getDistance(e0, v).doubleValue();
        double rv = distance.getDistance(e1, v).doubleValue();
        if (lu == lv || ru == rv) {
            return null;
        }
        if (lu > lv && ru > rv) {
            return null;
        }
        if (lu < lv && ru < rv) {
            return null;
        }
        double t1 = 0.5 * (rv - lu + l);
        double t2 = 0.5 * (ru - lv + l);
        if (t1 + lu <= l - t1 + ru) {
            return t1;
        }
        return t2;
    }

    static <V> List<V> distanceOrderedVertices(Distance<V> distance, V v, final Comparator<V> comparator) {
        final Map<V, Number> map = distance.getDistanceMap(v);
        ArrayList<V> list = new ArrayList<V>(map.keySet());
        Collections.sort(list, new Comparator<V>(){

            @Override
            public int compare(V a, V b) {
                if (((Number)map.get(a)).equals(map.get(b))) {
                    return comparator == null ? 0 : comparator.compare(a, b);
                }
                return Double.valueOf(((Number)map.get(b)).doubleValue()).compareTo(((Number)map.get(a)).doubleValue());
            }
        });
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LocalCenter<V, E>
    implements Transformer<E, Center<V, E>> {
        private final UndirectedGraph<V, E> d_graph;
        private final Distance<V> d_distance;
        private final Transformer<E, Number> d_edgeLength;
        private final Map<V, List<V>> d_orderedVertices = new HashMap<V, List<V>>();

        public LocalCenter(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Distance<V> distance) {
            this(graph, edgeLength, distance, null);
        }

        public LocalCenter(UndirectedGraph<V, E> graph, Transformer<E, Number> edgeLength, Distance<V> distance, Comparator<V> vertexComparator) {
            this.d_graph = graph;
            this.d_edgeLength = edgeLength;
            this.d_distance = distance;
            for (Object v : this.d_graph.getVertices()) {
                this.d_orderedVertices.put((List<V>)v, (List<List<V>>)AbsoluteOneCenter.distanceOrderedVertices(distance, v, vertexComparator));
            }
        }

        private double d(V u, V v) {
            return this.d_distance.getDistance(u, v).doubleValue();
        }

        private double de(PointOnEdge<V, E> x, V v) {
            return Math.min(x.getDistance() + this.d(x.getVertex0(), v), this.l(x) - x.getDistance() + this.d(x.getVertex1(), v));
        }

        private double l(PointOnEdge<V, E> x) {
            return this.d_edgeLength.transform(x.getEdge()).doubleValue();
        }

        private PointOnEdge<V, E> xr(PointOnEdge<V, E> x) {
            return new PointOnEdge<V, E>(x.getEdge(), x.getVertex0(), x.getVertex1(), 0.0);
        }

        private PointOnEdge<V, E> xs(PointOnEdge<V, E> x) {
            return new PointOnEdge<V, E>(x.getEdge(), x.getVertex0(), x.getVertex1(), this.l(x));
        }

        private PointOnEdge<V, E> xt(PointOnEdge<V, E> x, double t) {
            return new PointOnEdge<V, E>(x.getEdge(), x.getVertex0(), x.getVertex1(), t);
        }

        @Override
        public Center<V, E> transform(E edge) {
            double ds;
            Object vr = this.d_graph.getEndpoints(edge).getFirst();
            Object vs = this.d_graph.getEndpoints(edge).getSecond();
            PointOnEdge xr = new PointOnEdge(edge, vr, vs, 0.0);
            PointOnEdge xs = this.xs(xr);
            Center c = null;
            double dr = this.de(xr, this.d_orderedVertices.get(vr).get(0));
            c = dr <= (ds = this.de(xs, this.d_orderedVertices.get(vs).get(0))) ? new Center(xr, dr) : new Center(xs, ds);
            if (this.d_orderedVertices.get(vr).get(0) == this.d_orderedVertices.get(vs).get(0)) {
                return c;
            }
            return this.step3(c, this.d_orderedVertices.get(vr).get(0), 0);
        }

        private Center<V, E> step3(Center<V, E> c, V vm, int i) {
            V v = this.d_orderedVertices.get(c.getVertex0()).get(i + 1);
            if (this.de(this.xs(c), v) != this.de(this.xs(c), vm)) {
                return this.step4(c, vm, i + 1);
            }
            if (this.de(this.xr(c), v) > this.de(this.xs(c), vm)) {
                return this.step3(c, v, i + 1);
            }
            return this.step3(c, vm, i + 1);
        }

        private Center<V, E> step4(Center<V, E> c, V vm, int i) {
            V vbar = vm;
            if (this.isLastVertex(i)) {
                return this.step8(c, vbar);
            }
            vm = this.d_orderedVertices.get(c.getVertex0()).get(i);
            return this.step5(c, vm, vbar, i);
        }

        private boolean isLastVertex(int i) {
            return i == this.d_graph.getVertexCount() - 1;
        }

        private Center<V, E> step5(Center<V, E> c, V vm, V vbar, int i) {
            V v = this.d_orderedVertices.get(c.getVertex0()).get(i + 1);
            if (this.de(this.xr(c), v) != this.de(this.xr(c), vm)) {
                return this.step6(c, vm, vbar, i + 1);
            }
            if (this.de(this.xs(c), v) > this.de(this.xs(c), vm)) {
                return this.step5(c, v, vbar, i + 1);
            }
            return this.step5(c, vm, vbar, i + 1);
        }

        private Center<V, E> step6(Center<V, E> c, V vm, V vbar, int i) {
            Double tm = AbsoluteOneCenter.intersect(this.d_distance, c.getVertex0(), c.getVertex1(), this.l(c), vm, vbar);
            if (tm == null) {
                return this.step7(c, vm, vbar, i);
            }
            PointOnEdge<V, E> xt = this.xt(c, tm);
            Center<V, E> ct = new Center<V, E>(xt, this.de(xt, vm));
            if (ct.getRadius() < c.getRadius()) {
                return this.step7(ct, vm, vbar, i);
            }
            return this.step7(c, vm, vbar, i);
        }

        private Center<V, E> step7(Center<V, E> c, V vm, V vbar, int i) {
            if (this.de(this.xs(c), vm) > this.de(this.xs(c), vbar)) {
                vbar = vm;
            }
            if (this.isLastVertex(i)) {
                return this.step8(c, vbar);
            }
            return this.step5(c, this.d_orderedVertices.get(c.getVertex0()).get(i), vbar, i);
        }

        private Center<V, E> step8(Center<V, E> c, V vbar) {
            V vn = this.d_orderedVertices.get(c.getVertex0()).get(this.d_graph.getVertexCount() - 1);
            Double tm = AbsoluteOneCenter.intersect(this.d_distance, c.getVertex0(), c.getVertex1(), this.l(c), vn, vbar);
            if (tm == null) {
                return c;
            }
            PointOnEdge<V, E> xt = this.xt(c, tm);
            Center<V, E> ct = new Center<V, E>(xt, this.de(xt, vn));
            if (ct.getRadius() < c.getRadius()) {
                return ct;
            }
            return c;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Center<V, E>
    extends PointOnEdge<V, E> {
        private final double d_r;

        public Center(E e, V v0, V v1, double t, double r) {
            super(e, v0, v1, t);
            this.d_r = r;
        }

        public Center(PointOnEdge<V, E> x, double r) {
            this(x.getEdge(), x.getVertex0(), x.getVertex1(), x.getDistance(), r);
        }

        public double getRadius() {
            return this.d_r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UnitLength<E>
    implements Transformer<E, Number> {
        @Override
        public Number transform(E input) {
            return 1.0;
        }
    }
}

