/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.mtc.parameterization;

import org.drugis.mtc.model.Treatment;
import org.drugis.mtc.parameterization.NetworkParameter;
import org.drugis.mtc.parameterization.TreatmentComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicParameter
implements NetworkParameter,
Comparable<BasicParameter> {
    private final Treatment d_base;
    private final Treatment d_subj;

    public BasicParameter(Treatment base, Treatment subj) {
        this.d_base = base;
        this.d_subj = subj;
    }

    @Override
    public String getName() {
        return "d." + this.d_base.getId() + "." + this.d_subj.getId();
    }

    public Treatment getBaseline() {
        return this.d_base;
    }

    public Treatment getSubject() {
        return this.d_subj;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object o) {
        if (o instanceof BasicParameter) {
            BasicParameter other = (BasicParameter)o;
            return this.d_base.equals(other.d_base) && this.d_subj.equals(other.d_subj);
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.d_base.hashCode() + this.d_subj.hashCode();
    }

    @Override
    public int compareTo(BasicParameter other) {
        int c1 = TreatmentComparator.INSTANCE.compare(this.d_base, other.d_base);
        return c1 == 0 ? TreatmentComparator.INSTANCE.compare(this.d_subj, other.d_subj) : c1;
    }
}

