/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.transformation;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldingTransformerFixed<V, E> {
    public static <V, E> Graph<V, E> foldKPartiteGraph(KPartiteGraph<V, E> g, Predicate<V> p, Factory<Graph<V, E>> graph_factory, Factory<E> edge_factory) {
        Graph<V, E> newGraph = graph_factory.create();
        Collection<V> vertices = g.getVertices(p);
        for (V v : vertices) {
            newGraph.addVertex(v);
            for (V s : g.getSuccessors(v)) {
                for (V t : g.getSuccessors(s)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    newGraph.addEdge(edge_factory.create(), v, t);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> Graph<V, Collection<V>> foldKPartiteGraph(KPartiteGraph<V, E> g, Predicate<V> p, Factory<Graph<V, Collection<V>>> graph_factory) {
        Graph<V, Collection<V>> newGraph = graph_factory.create();
        Collection<V> vertices = g.getVertices(p);
        for (V v : vertices) {
            newGraph.addVertex(v);
            for (V s : g.getSuccessors(v)) {
                for (V t : g.getSuccessors(s)) {
                    if (!vertices.contains(t) || t.equals(v)) continue;
                    newGraph.addVertex(t);
                    ArrayList<V> v_coll = (ArrayList<V>)newGraph.findEdge(v, t);
                    if (v_coll == null) {
                        v_coll = new ArrayList<V>();
                        newGraph.addEdge(v_coll, v, t);
                    }
                    v_coll.add(s);
                }
            }
        }
        return newGraph;
    }

    public static <V, E> UndirectedGraph<V, FoldedEdge<V, E>> foldHypergraphEdges(Hypergraph<V, E> h, Factory<UndirectedGraph<V, FoldedEdge<V, E>>> graph_factory) {
        UndirectedGraph<V, FoldedEdge<V, E>> target = graph_factory.create();
        for (V v : h.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h.getEdges()) {
            ArrayList<V> incident = new ArrayList<V>(h.getIncidentVertices(e));
            FoldingTransformerFixed.populateTarget(target, e, incident);
        }
        return target;
    }

    public static <V, E> UndirectedGraph<V, E> foldHypergraphEdges(Hypergraph<V, E> h, Factory<UndirectedGraph<V, E>> graph_factory, Factory<E> edge_factory) {
        UndirectedGraph<V, E> target = graph_factory.create();
        for (V v : h.getVertices()) {
            target.addVertex(v);
        }
        for (Object e : h.getEdges()) {
            ArrayList<V> incident = new ArrayList<V>(h.getIncidentVertices(e));
            for (int i = 0; i < incident.size(); ++i) {
                for (int j = i + 1; j < incident.size(); ++j) {
                    target.addEdge(edge_factory.create(), incident.get(i), incident.get(j));
                }
            }
        }
        return target;
    }

    public static <V, E, F> UndirectedGraph<E, F> foldHypergraphVertices(Hypergraph<V, E> h, Factory<UndirectedGraph<E, F>> graph_factory, Factory<F> edge_factory) {
        UndirectedGraph<F, F> target = graph_factory.create();
        for (E e : h.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h.getVertices()) {
            ArrayList<E> incident = new ArrayList<E>(h.getIncidentEdges(v));
            for (int i = 0; i < incident.size(); ++i) {
                for (int j = i + 1; j < incident.size(); ++j) {
                    target.addEdge(edge_factory.create(), incident.get(i), incident.get(j));
                }
            }
        }
        return target;
    }

    public UndirectedGraph<E, FoldedEdge<E, V>> foldHypergraphVertices(Hypergraph<V, E> h, Factory<UndirectedGraph<E, FoldedEdge<E, V>>> graph_factory) {
        UndirectedGraph<E, FoldedEdge<E, E>> target = graph_factory.create();
        for (E e : h.getEdges()) {
            target.addVertex(e);
        }
        for (Object v : h.getVertices()) {
            ArrayList<E> incident = new ArrayList<E>(h.getIncidentEdges(v));
            FoldingTransformerFixed.populateTarget(target, v, incident);
        }
        return target;
    }

    private static <S, T> void populateTarget(UndirectedGraph<S, FoldedEdge<S, T>> target, T e, ArrayList<S> incident) {
        for (int i = 0; i < incident.size(); ++i) {
            S v1 = incident.get(i);
            for (int j = i + 1; j < incident.size(); ++j) {
                S v2 = incident.get(j);
                FoldedEdge e_coll = (FoldedEdge)target.findEdge(v1, v2);
                if (e_coll == null) {
                    e_coll = new FoldedEdge(v1, v2);
                    target.addEdge(e_coll, v1, v2);
                }
                e_coll.getFolded().add(e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FoldedEdge<V, E> {
        private Pair<V> d_vertices;
        private Collection<E> d_folded;

        public FoldedEdge(V v1, V v2) {
            this.d_vertices = new Pair<V>(v1, v2);
            this.d_folded = new ArrayList();
        }

        public Pair<V> getVertices() {
            return this.d_vertices;
        }

        public Collection<E> getFolded() {
            return this.d_folded;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FoldedEdge) {
                FoldedEdge other = (FoldedEdge)obj;
                return other.d_vertices.equals(this.d_vertices);
            }
            return false;
        }

        public int hashCode() {
            return this.d_vertices.hashCode();
        }
    }
}

