/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections15.keyvalue;

import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiKey<K>
implements Serializable {
    private static final long serialVersionUID = 4465448607415788805L;
    private final K[] keys;
    private final int hashCode;

    public MultiKey(K ... keys) {
        this(keys, true);
    }

    public MultiKey(K[] keys, boolean makeClone) {
        if (keys == null) {
            throw new IllegalArgumentException("The array of keys must not be null");
        }
        this.keys = makeClone ? (Object[])keys.clone() : keys;
        int total = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) continue;
            total ^= keys[i].hashCode();
        }
        this.hashCode = total;
    }

    public K[] getKeys() {
        return (Object[])this.keys.clone();
    }

    public K getKey(int index) {
        return this.keys[index];
    }

    public int size() {
        return this.keys.length;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiKey) {
            MultiKey otherMulti = (MultiKey)other;
            return Arrays.equals(this.keys, otherMulti.keys);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "MultiKey" + Arrays.asList(this.keys).toString();
    }
}

