% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootPairs.R
\name{bootPairs}
\alias{bootPairs}
\title{Compute matrix of n999 rows and p-1 columns of bootstrap `sum' 
(strength from Cr1 to Cr3).}
\usage{
bootPairs(mtx, ctrl = 0, n999 = 9)
}
\arguments{
\item{mtx}{{data matrix with two or more columns}}

\item{ctrl}{{data matrix having control variable(s) if any}}

\item{n999}{{Number of bootstrap replications (default=9)}}
}
\value{
out {When \code{mtx} has p columns, the first output called \code{out}
of \code{bootPairs(mtx)} is a matrix of n999 rows and p-1 columns
each containing resampled `sum' values summarizing the weighted sums 
associated with all three  criteria from the function \code{silentPairs(mtx)}
applied to each bootstrap sample separately.} 

{probSign} {The second output 
called \code{probSign} is  a p-1 vector
of probabilities of correct signs assuming that the mean of n999 values
has the correct sign and assuming that sum index values inside the
range [-0.05, 0.05] are neither positive nor negative but ambiguous}
}
\description{
Maximum entropy bootstrap (meboot) package is used for statistical inference
using the sum of three signs sg1 to sg3 from the three criteria Cr1 to Cr3 to
assess preponderance of evidence in favor of a sign. (+1, 0, -1).
The bootstrap output can be analyzed to assess approximate
preponderance of a particular sign which determines
the causal direction.
}
\note{
This computation is computer intensive and generally very slow. 
  It may be better to use
  it at a later stage in the investigation when a preliminary 
  causal determination 
  is already made.
A positive sign for j-th weighted sum reported in the column `sum' means
that the first variable listed in the argument matrix \code{mtx} is the 
`kernel cause' of the variable in the (j+1)-th column of \code{mtx}.
}
\examples{
\dontrun{
options(np.messages = FALSE)
set.seed(34);x=sample(1:10);y=sample(2:11)
bb=bootPairs(cbind(x,y),n999=29)
apply(bb$out,2,summary) #gives summary stats for n999 bootstrap sum computations
bb$probSign #reports success proportion out of n999


bb=bootPairs(airquality,n999=999);options(np.messages=FALSE)
apply(bb$out,2,summary) #gives summary stats for n999 bootstrap sum computations
bb$probSign #reports success proportion out of n999 replicates

data('EuroCrime')
attach(EuroCrime)
bootPairs(cbind(crim,off),n999=29) #col.1= crim causes off hence positive signs
#note that n999=29 is too small for real problems, chosen for quickness here.
}
}
\references{
Vinod, H. D. `Generalized Correlation and Kernel Causality with 
 Applications in Development Economics' in Communications in 
 Statistics -Simulation and Computation, 2015, 
 \url{http://dx.doi.org/10.1080/03610918.2015.1122048}

Zheng, S., Shi, N.-Z., and Zhang, Z. (2012). Generalized measures 
 of correlation for asymmetry, nonlinearity, and beyond. 
 Journal of the American Statistical Association, vol. 107, pp. 1239-1252.

Vinod, H. D. and Lopez-de-Lacalle, J. (2009). 'Maximum entropy bootstrap
 for time series: The meboot R package.' Journal of Statistical Software,
 Vol. 29(5), pp. 1-19.

Vinod, H. D. Causal Paths and Exogeneity Tests 
in {Generalcorr} Package for Air Pollution and Monetary Policy 
(June 6, 2017). Available at SSRN: \url{https://ssrn.com/abstract=2982128}
}
\seealso{
See Also \code{\link{silentPairs}}.
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
\keyword{asymmetric}
\keyword{correlations}
\keyword{kernel}
\keyword{regression,}
