% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genesys.R
\name{fetch_accessions}
\alias{fetch_accessions}
\title{Fetch accession passport data and return the paged data structure for further processing.
\code{\link{get_accessions}} might be more useful as it returns a data table.}
\usage{
fetch_accessions(
  filters = list(),
  page = NULL,
  size = 1000,
  selector = NULL,
  at.least = NULL
)
}
\arguments{
\item{filters}{an R \code{structure} with Genesys filters}

\item{page}{the page index (0-based)}

\item{size}{number of records to load per page (page size)}

\item{selector}{NULL or a function to "select" variables of interest}

\item{at.least}{stop fetching when at.least records are received from Genesys}
}
\value{
Paged data structure
}
\description{
Fetch accession passport data and return the paged data structure for further processing.
\code{\link{get_accessions}} might be more useful as it returns a data table.
}
\examples{
\dontrun{
  # Retrieve all accession data by country of origin
  accessions <- genesysr::fetch_accessions(mcpd_filter(ORIGCTY = c("DEU", "SVN")))

  # Fetch Musa
  musa <- genesysr::fetch_accessions(list(taxonomy.genus = c('Musa')))

  # Apply selector function
  accessions <- genesysr::fetch_accessions(
    mcpd_filter(ORIGCTY = c("DEU", "SVN")),
    selector = function(x) {
      list(id = x$id, acceNumb = x$acceNumb, instCode = x$institute$code)
    }
  )
}

}
\seealso{
\code{\link{get_accessions}}
}
