#
# $Id: HWE.test.Rd,v 1.10 2002/11/27 15:32:20 warnesgr Exp $
#
# $Log: HWE.test.Rd,v $
# Revision 1.10  2002/11/27 15:32:20  warnesgr
# Correct spelling errors and typos.
#
# Revision 1.9  2002/11/12 19:58:44  warnesgr
# - Changes to remove warnings generated by 'R CMD check'.
#
# Revision 1.8  2002/11/08 21:07:28  warnesgr
#
# - DESCRIPTION: Updated version number and date
# - TODO: Updated todo list.
#
# Revision 1.7  2002/09/24 01:32:19  warnesgr
# - 'Un-genericized' diseq()
# - Moved documentation of diseq() and diseq from HWE.test.Rd to diseq.Rd
# - Cleaned up HWE.test.Rd and diseq.Rd
# - Fixed broken class check in diseq() and diseq.ci()
# - Removed allele.count.default() -- this will force the user to
#   explicitly call 'genotype' on the data to use allele.count().
# - Added zzz.R to require package 'boot'
#
# Revision 1.6  2002/09/24 00:02:01  WarnesGR
# - Moved code that computed D-hat to diseq() and diseq.genotype() in diseq.R.
# - Added diseq.ci() to compute confidence interval for D-hat.
# - Added code to call diseq() and diseq.ci() from HWE.test()
# - Added arguments to HWE.test() and print.HWE.test() to control these new features
# - Added text to HWE.test.Rd documenting these new functions and arguments
#
# Revision 1.5  2002/06/18 19:38:41  warnesgr
#
# Changes to fix problems reported by R CMD check.
#
# Revision 1.4  2002/02/14 12:48:56  warnes
#
# - Added 'keywords' to HWE.test
# - Create undocumented.Rd to satisfy documentation requirements for
#   objects not otherwise included in documentation
# - Add 'alias' commands noting that 'genotype' and '[.haplotype' are
#   documented here.
#
# Revision 1.3  2001/06/28 19:15:29  warnes
# - Updated to match v1.4 of HWE.test.R.
#
# - Added CVS id and log fields to file.
#
#

\name{HWE.test}
\alias{HWE.test}
\alias{HWE.test.genotype}
\alias{print.HWE.test}

\title{Estimate Disequilibrium and Test for Hardy-Weinberg Equilibrium}

\description{
  Estimate disequilibrium parameter and test the null hypothesis that 
  Hardy-Weinberg equilibrium holds. 
}

\usage{
HWE.test(x, ...)
\method{HWE.test}{genotype}(x, simulate.p.value=TRUE, B=10000, conf=0.95, ci.B=1000, ... )
\method{print}{HWE.test}{x,show.table=TRUE,...}
}
\arguments{
  \item{x}{genotype or haplotype object.}
  \item{simulate.p.value}{a logical value indicating whether the p-value should
    be computed using simulation instead of using the
    \eqn{\chi^2}{Chi-Square} approximation. Defaults to \code{TRUE}.}
  \item{B}{Number of simulation iterations to use when
    \code{simulate.p.value=TRUE}. Defaults to 10000.}
  \item{conf}{Confidence level to use when computing the confidence
    level for D-hat.  Defaults to 0.95, should be in (0,1). }
  \item{ci.B}{Number of bootstrap iterations to use when computing the
    confidence interval. Defaults to 1000.}
%   \item{ci.type}{Method of calculating the confidence interval using the
%     bootstrap sample.  Defaults to \code{"basic"}.  See 
%     \code{\link[boot]{bootci}} for details.}
  \item{show.table}{a logical value indicating whether the details of
    computing the disequilibrium estimate should be displayed.  Defaults
    to \code{TRUE}.}
  \item{...}{ optional parameters passed to \code{chisq.test}}
}
\details{
  HWE.test calls \code{\link{diseq}} to computes the Hardy-Weinberg
  (dis)equilibrium statistics D, D', and r (correlation coefficient).
  Next it calls \code{\link{diseq.ci}} to compute a bootstrap confidence
  interval for these estimates.  Finally, it calls
  \code{\link{chisq.test}} to compute a p-value for Hardy-Weinberg
  Equilibrium using a simulation/permutation method.

  Using bootstrapping for the confidence interval and simulation for the
  p-value avoids reliance on the assumptions the underlying Chi-square
  approximation.  This is particularly important when some allele pairs
  have small counts.

  For details on the definition of D, D', and r, see the help page for
  \code{\link{diseq}}.
}
\value{
  An object of class \code{HWE.test} with components
  \item{diseq}{A \code{\link{diseq}} object providing details on the
    disequilibrium estimates.}
  \item{ci}{A \code{\link{diseq.ci}} object providing details on the
    bootstrap confidence intervals for the disequilibrium estimates.}
  \item{test}{A \code{\link[ctest]{htest}} object providing details on the
    permutation based Chi-square test.}
  \item{call}{function call used to creat this object.}
  \item{conf, B, ci.B, simulate.p.value}{values used for these arguments.}
}
\author{ Gregory R. Warnes \email{Gregory\_R\_Warnes@groton.pfizer.com }
  }

\seealso{
  \code{\link{diseq}},
  \code{\link{diseq.ci}},
  \code{\link{allele}},
  \code{\link{chisq.test}},
  \code{\link[boot]{boot}},
  \code{\link[boot]{bootci}}
}


\examples{
\testonly{
set.seed(4657613)
}
example.data   <- c("D/D","D/I","D/D","I/I","D/D",
                    "D/D","D/D","D/D","I/I","")
g1  <- genotype(example.data)
g1

diseq(g1)
diseq.ci(g1)
HWE.test(g1)

three.data   <- c(rep("A/A",8),
                  rep("C/A",20),
                  rep("C/T",20),
                  rep("C/C",10),
                  rep("T/T",3))

g3  <- genotype(three.data)
g3

HWE.test(g3, ci.B=10000)


}
\keyword{ misc }
%\keyword{genetics}
