% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_coding.R
\name{binary_coding}
\alias{binary_coding}
\title{Code genotypes as binary}
\usage{
binary_coding(genotype_warnings2NA, genotype_table)
}
\arguments{
\item{genotype_warnings2NA}{this is a genotypeR object that has been
through BC_Genotype_Warnings with either output="warnings2NA" or
output="pass_through"}

\item{genotype_table}{this is a marker table produced with
Ref_Alt_Table}
}
\value{
A data frame of binary coded genotypes as a slot in the
genotypeR input genotype_warnings2NA
}
\description{
\code{binary_coding} codes genotypes contained in a genotypeR object
and places them into a genotypeR object's binary_genotype slot.
}
\examples{

data(genotypes_data)
data(markers)
## genotype table
marker_names <- make_marker_names(markers)
GT_table <- Ref_Alt_Table(marker_names)
## remove those markers that did not work
genotypes_data_filtered <- genotypes_data[,c(1, 2, grep("TRUE",
colnames(genotypes_data)\%in\%GT_table$marker_names))]

warnings_out2NA <- initialize_genotypeR_data(seq_data = genotypes_data_filtered,
genotype_table = GT_table, output = "warnings2NA")

genotypes_object <- binary_coding(warnings_out2NA, GT_table)

}
\keyword{as}
\keyword{binary}
\keyword{code}
\keyword{genotypes}
