% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_calc_function.R
\name{expected.linear.ll}
\alias{expected.linear.ll}
\title{Function to Calculate Expected Log Likelihood for a Single Genotype}
\usage{
expected.linear.ll(mean_truth, mean_model, sd_y_x_truth, sd_y_x_model)
}
\arguments{
\item{mean_truth}{Mean of the outcome given X(predictors/genotype) under the true model.}

\item{mean_model}{Mean of the outcome given X(predictors/genotype) under the test model.}

\item{sd_y_x_truth}{The standard deviation of Y given X (predictors/genotype) given genotype under the true model.}

\item{sd_y_x_model}{The standard deviation of Y (the outcome) given X (predictors/genotype) under the test model.}
}
\value{
The log likelihood.
}
\description{
Calculates the expected log likelihood for a single genotype given the true and estimated mean and standard deviation for the outcome.
}
\examples{
expected.linear.ll(mean_truth = 0, mean_model = 0.03,
 sd_y_x_model = 1, sd_y_x_truth = 0.9544108)

}
