% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_calc_function.R
\name{calc.like.linear}
\alias{calc.like.linear}
\title{Function to Calculate Log Likelihood for a Linear Regression Model}
\usage{
calc.like.linear(beta, m, es_ab, es_bb, sd_y_x_model, sd_y_x_truth, model)
}
\arguments{
\item{beta}{Vector of linear regression coefficients.}

\item{m}{Minor allele frequency.}

\item{es_ab}{effect size for mean AB - mean AA}

\item{es_bb}{effect size for mean BB - mean AA}

\item{sd_y_x_model}{The standard deviation of Y (the outcome) given X (predictors/genotype) under the test model.}

\item{sd_y_x_truth}{The standard deviation of Y given X (predictors/genotype) given genotype under the true model.}

\item{model}{The genetic model in the linear regression: "Dominant", "Additive", "Recessive", "2df" or "null"}
}
\value{
The log likelihood.
}
\description{
Convenience function to calculate the log likelihood of a specified model.
}
\examples{
calc.like.linear(beta = c(0.0000000, 0.1578947), m = 0.1, es_ab = 0, es_bb = 3, 
 sd_y_x_model = 0.9980797, sd_y_x_truth = 0.9544108, model = "Dominant")

}
