% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.gensvm.grid.R
\name{plot.gensvm.grid}
\alias{plot.gensvm.grid}
\title{Plot the simplex space of the best fitted model in the GenSVMGrid}
\usage{
\method{plot}{gensvm.grid}(x, ...)
}
\arguments{
\item{x}{A \code{gensvm.grid} object trained with refit=TRUE}

\item{...}{further arguments are passed to the plot function}
}
\value{
returns the object passed as input
}
\description{
This is a wrapper which calls the plot function for the best 
model in the provided GenSVMGrid object. See the documentation for 
\code{\link{plot.gensvm}} for more information.
}
\examples{
\donttest{
x <- iris[, -5]
y <- iris[, 5]

grid <- gensvm.grid(x, y)
plot(grid, x)
}

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{http://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{plot.gensvm}}, \code{\link{gensvm.grid}}, 
\code{\link{predict.gensvm.grid}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
