% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gensvm.refit.R
\name{gensvm.refit}
\alias{gensvm.refit}
\title{Train an already fitted model on new data}
\usage{
gensvm.refit(
  fit,
  x,
  y,
  p = NULL,
  lambda = NULL,
  kappa = NULL,
  epsilon = NULL,
  weights = NULL,
  kernel = NULL,
  gamma = NULL,
  coef = NULL,
  degree = NULL,
  kernel.eigen.cutoff = NULL,
  max.iter = NULL,
  verbose = NULL,
  random.seed = NULL
)
}
\arguments{
\item{fit}{Fitted \code{gensvm} object}

\item{x}{Data matrix of the new data}

\item{y}{Label vector of the new data}

\item{p}{if NULL use the value from \code{fit} in the new model, otherwise 
override with this value.}

\item{lambda}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{kappa}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{epsilon}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{weights}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{kernel}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{gamma}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{coef}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{degree}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{kernel.eigen.cutoff}{if NULL use the value from \code{fit} in the new 
model, otherwise override with this value.}

\item{max.iter}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{verbose}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}

\item{random.seed}{if NULL use the value from \code{fit} in the new model, 
otherwise override with this value.}
}
\value{
a new fitted \code{gensvm} model
}
\description{
This function can be used to train an existing model on new 
data or fit an existing model with slightly different parameters. It is 
useful for retraining without having to copy all the parameters over. One 
common application for this is to refit the best model found by a grid 
search, as illustrated in the examples.
}
\examples{
x <- iris[, -5]
y <- iris[, 5]

# fit a standard model and refit with slightly different parameters
fit <- gensvm(x, y)
fit2 <- gensvm.refit(fit, x, y, epsilon=1e-8)

\donttest{
# refit a model returned by a grid search
grid <- gensvm.grid(x, y)
fit <- gensvm.refit(fit, x, y, epsilon=1e-8)
}

# refit on different data
idx <- runif(nrow(x)) > 0.5
x1 <- x[idx, ]
x2 <- x[!idx, ]
y1 <- y[idx]
y2 <- y[!idx]

fit1 <- gensvm(x1, y1)
fit2 <- gensvm.refit(fit1, x2, y2)

}
\references{
Van den Burg, G.J.J. and Groenen, P.J.F. (2016). \emph{GenSVM: A Generalized 
Multiclass Support Vector Machine}, Journal of Machine Learning Research, 
17(225):1--42. URL \url{https://jmlr.org/papers/v17/14-526.html}.
}
\seealso{
\code{\link{gensvm}}, \code{\link{gensvm-package}}
}
\author{
Gerrit J.J. van den Burg, Patrick J.F. Groenen \cr
Maintainer: Gerrit J.J. van den Burg <gertjanvandenburg@gmail.com>
}
