% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-Methods.R
\docType{methods}
\name{spc.interp.spectral}
\alias{spc.interp.spectral}
\alias{spc.interp.spectral,Spectra-method}
\title{Interpolate spectral values}
\usage{
spc.interp.spectral(source1,target_lbd,show.plot, ...)

\S4method{spc.interp.spectral}{Spectra}(source1, target_lbd,
  show.plot = FALSE)
}
\arguments{
\item{source1}{A \code{Spectra} object}

\item{target_lbd}{numeric vector giving desired wavelengths}

\item{show.plot}{logical TRUE if a graphical representation is required}

\item{...}{further arguments to pass on to approx().}
}
\description{
Estimate spectral data at a new set of wavelengths through interpolation
using approx().
}
\examples{
sp=spc.example_spectra()
lbd = as.numeric(c(412,440,490,555,670))
sp2 = spc.interp.spectral(sp[,lbd],c(430,450,500))
spc.plot.overlay(SpcList(list(sp,sp2)))

#Quick Plot only the first row
spc.interp.spectral(sp[,lbd],c(430,450,500),show.plot=TRUE)

}
