% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_intermediate_region.R
\name{read_intermediate_region}
\alias{read_intermediate_region}
\title{Download shape files of Brazil's Intermediate Geographic Areas as sf objects.}
\usage{
read_intermediate_region(
  code_intermediate = "all",
  year = NULL,
  tp = "simplified"
)
}
\arguments{
\item{code_intermediate}{4-digit code of an intermediate region. If the two-digit code or a two-letter uppercase abbreviation of
a state is passed, (e.g. 33 or "RJ") the function will load all intermediate regions of that state. If code_intermediate="all",
all intermediate regions of the country are loaded (defaults to "all").}

\item{year}{A date number in YYYY format (defaults to 2017)}

\item{tp}{Whether the function returns the 'original' dataset with high resolution or a dataset with 'simplified' borders (Default)}
}
\description{
The intermediate Geographic Areas are part of the geographic division of Brazil created in 2017 by IBGE to
replace the "Meso Regions" division. Data at scale 1:250,000, using Geodetic reference system "SIRGAS2000" and CRS(4674)
}
\examples{
\donttest{

library(geobr)

# Read an specific intermediate region
  im <- read_intermediate_region(code_intermediate=1202)

# Read intermediate regions of a state
  im <- read_intermediate_region(code_intermediate=12)
  im <- read_intermediate_region(code_intermediate="AM")

# Read all intermediate regions of the country
  im <- read_intermediate_region()
  im <- read_intermediate_region(code_intermediate="all")
}


}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_census_tract}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_immediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
