% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_biomes.R
\name{read_biomes}
\alias{read_biomes}
\title{Download official data of Brazilian biomes as an sf object.}
\usage{
read_biomes(year = 2019, simplified = TRUE, showProgress = TRUE)
}
\arguments{
\item{year}{A date number in YYYY format (defaults to 2019)}

\item{simplified}{Logic FALSE or TRUE, indicating whether the function returns the
data set with 'original' resolution or a data set with 'simplified' borders (Defaults to TRUE).
For spatial analysis and statistics users should set simplified = FALSE. Borders have been
simplified by removing vertices of borders using st_simplify{sf} preserving topology with a dTolerance of 100.}

\item{showProgress}{Logical. Defaults to (TRUE) display progress bar}
}
\description{
This data set includes  polygons of all biomes present in Brazilian territory and coastal area.
The latest data set dates to 2019 and it is available at scale 1:250.000. The 2004 data set is at
the scale 1:5.000.000. The original data comes from IBGE. More information at https://www.ibge.gov.br/apps/biomas/
}
\examples{
\donttest{

library(geobr)

# Read biomes
  b <- read_biomes(year=2019)

}

}
\seealso{
Other general area functions: 
\code{\link{read_amazon}()},
\code{\link{read_census_tract}()},
\code{\link{read_conservation_units}()},
\code{\link{read_country}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_weighting_area}()}
}
\concept{general area functions}
