% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_schools.R
\name{read_schools}
\alias{read_schools}
\title{Download geolocated data of schools}
\usage{
read_schools(year = 2020, showProgress = TRUE)
}
\arguments{
\item{year}{Numeric. Year of the data in YYYY format. Defaults to \code{2020}.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar.}
}
\value{
An \verb{"sf" "data.frame"} object
}
\description{
Data comes from the School Census collected by INEP, the National Institute
for Educational Studies and Research Anisio Teixeira. The date of the last
data update is registered in the database in the column 'date_update'. These
data uses Geodetic reference system "SIRGAS2000" and CRS(4674). The coordinates
of each school if collected by INEP. Periodically the coordinates are revised
with the objective of improving the quality of the data. More information
available at \url{https://www.gov.br/inep/pt-br/acesso-a-informacao/dados-abertos/inep-data/catalogo-de-escolas/}
}
\examples{
\dontshow{if (identical(tolower(Sys.getenv("NOT_CRAN")), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Read all schools in the country
s <- read_schools( year = 2020)
\dontshow{\}) # examplesIf}
}
\seealso{
Other area functions: 
\code{\link{read_amazon}()},
\code{\link{read_biomes}()},
\code{\link{read_capitals}()},
\code{\link{read_comparable_areas}()},
\code{\link{read_country}()},
\code{\link{read_disaster_risk_area}()},
\code{\link{read_health_facilities}()},
\code{\link{read_health_region}()},
\code{\link{read_immediate_region}()},
\code{\link{read_indigenous_land}()},
\code{\link{read_intermediate_region}()},
\code{\link{read_meso_region}()},
\code{\link{read_metro_area}()},
\code{\link{read_micro_region}()},
\code{\link{read_municipal_seat}()},
\code{\link{read_municipality}()},
\code{\link{read_neighborhood}()},
\code{\link{read_pop_arrangements}()},
\code{\link{read_region}()},
\code{\link{read_semiarid}()},
\code{\link{read_state}()},
\code{\link{read_statistical_grid}()},
\code{\link{read_urban_area}()},
\code{\link{read_urban_concentrations}()},
\code{\link{read_weighting_area}()}
}
\concept{area functions}
