% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_base_dens.R
\name{get_base_dens}
\alias{get_base_dens}
\title{Get the baseline density}
\usage{
get_base_dens(
  window,
  option,
  ndim = 256,
  out_data,
  out_coordinates = c("longitude", "latitude"),
  hfr,
  dep_var,
  indep_var,
  ratio
)
}
\arguments{
\item{window}{owin object}

\item{option}{"in" (using in-sample data) or "out" (using out-of-sample data)}

\item{ndim}{the number of dimensions of grid cells (ndim^2). By default, ndim = 256.}

\item{out_data}{dataframe (if using out-of-sample data)}

\item{out_coordinates}{vector of column names of longitudes and latitudes (in this order) (if using in-sample data)}

\item{hfr}{hyperframe (if using in-sample data)}

\item{dep_var}{the name of the dependent variable (if using in-sample data)}

\item{indep_var}{the names of time-invariant independent varaibles (if using in-sample data)}

\item{ratio}{for random sampling of data (if using in-sample data)}
}
\value{
an im object of baseline density
}
\description{
`get_base_dens()` takes a dataframe and
returns the baseline densities using Scott's rule of thumb (out-of-sample data)
or fitting an inhomogeneous Poisson model (in-sample data) by regressing
the in-sample data on time-invariant covariates.
}
