% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_functions.R
\name{spatialDiag}
\alias{spatialDiag}
\title{Spatial diagnostic}
\usage{
spatialDiag(belongmatrix, nblistw, undecided = NULL, nrep = 50)
}
\arguments{
\item{belongmatrix}{A membership matrix}

\item{nblistw}{A list.w  object describing the neighbours (spdep package)}

\item{undecided}{A float between 0 and 1 giving the minimum value that an
observation must get in the membership matrix to not be considered as
uncertain (default = NULL)}

\item{nrep}{An integer indicating the number of permutation to do to simulate
the random distribution of the spatial inconsistency}
}
\value{
A named list with :
\itemize{
        \item MoranValues : the moran I values fo each column of the membership
         matrix (spdep::MoranI)
        \item JoinCounts : the result of the join count test calculated with
         the most likely group for each datapoint (spdep::joincount.multi)
        \item SpConsist : the mean value of the spatial consistency index
        (the lower, the better, see ?spConsistency for details)
}
}
\description{
Utility function to facilitate the spatial diagnostic of a classification

Calculate the following indicators : Moran I index (spdep::moranI) for each
column of the belonging matrix, Join count test (spdep::joincount.multi) for
the most likely groups of each datapoint, Spatial consistency index (see
function spConsistency)
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- LyonIris@data[AnalysisFields]
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
spatialDiag(result$Belongings, Wqueen, undecided=0.45, nrep=30)
}
