% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/movingwindow.R
\name{pad_edges}
\alias{pad_edges}
\title{Extend edges of a raster or matrix.}
\usage{
pad_edges(x, size = 11, val = NULL)
}
\arguments{
\item{x}{A raster or matrix.}

\item{size}{Numeric. Number of pixels to add to each side.}

\item{val}{Numeric. If NULL (default), this extends the edge values
out. If not null, this value will be used for the extended cells.}
}
\value{
A raster with edges padded \code{size} number of pixels on each edge.
}
\description{
Extends edge values of a raster or matrix by a specified number of pixels.
}
\examples{
library(raster)

# import raster image
data(normforest)

# crop raster to much smaller area
x <- pad_edges(normforest, 11)
}
