% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maps.R
\name{ccri_variance}
\alias{ccri_variance}
\title{Calculate variance of CCRI}
\usage{
ccri_variance(
  indices,
  rast,
  global,
  east = NULL,
  west = NULL,
  geoscale,
  res = reso(),
  outdir = tempdir()
)
}
\arguments{
\item{indices}{SpatRaster. Collection of risk indices.}

\item{rast}{SpatRaster. Template for variance output}

\item{global}{Logical. \code{TRUE} if global analysis is desired, \code{FALSE} otherwise.
\code{east} and \code{west} are required when \code{TRUE}.}

\item{east}{SpatRaster. Collection of risk indices on eastern extent.}

\item{west}{SpatRaster. Collection of risk indices on western extent.
When \code{TRUE}, \code{geoscale} is ignored. Default is \code{TRUE}.}

\item{geoscale}{Vector. geographical scale. Default is \code{NULL}.}

\item{res}{Numeric. Map resolution. This value is used in aggregation and dis-aggregation operation.
Default is \code{\link[=reso]{reso()}}.}

\item{outdir}{Character. Output directory for saving raster in TIFF format.
Default is \code{\link[=tempdir]{tempdir()}}.}
}
\value{
RiskMap. Contains result in the form of \code{SpatRaster} objects
and file path of the saved maps.
}
\description{
This function produces a map of variance of CCRI based on input parameters
}
