% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waitUntilFinished.R
\docType{methods}
\name{wait}
\alias{wait}
\alias{wait,character,missing-method}
\alias{wait,character,numeric-method}
\alias{wait,geojob,missing-method}
\alias{wait,geojob,numeric-method}
\title{hold up R while GDP is processing}
\usage{
wait(.Object, sleep.time)

\S4method{wait}{geojob,numeric}(.Object, sleep.time)

\S4method{wait}{geojob,missing}(.Object, sleep.time)

\S4method{wait}{character,numeric}(.Object, sleep.time)

\S4method{wait}{character,missing}(.Object, sleep.time)
}
\arguments{
\item{.Object}{a geojob}

\item{sleep.time}{a number of seconds to wait in between checking the process}
}
\value{
invisible return of .Object, unaltered
}
\description{
keeps R in a loop while GDP works on the request. Checks \code{\link{running}}. 
Will drop out of loop whenever !running(geojob)
}
\examples{
\dontrun{
job <- geoknife(stencil = c(-89,42), fabric = 'prism')
2+2
wait(job)
check(job) # should be complete
}
}

