% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLGridEnvelope.R
\docType{class}
\name{GMLGridEnvelope}
\alias{GMLGridEnvelope}
\title{GMLGridEnvelope}
\format{
\code{\link{R6Class}} object.
}
\arguments{
\item{xml}{object of class \code{XMLInternalNode-class} from \pkg{XML}}

\item{bbox}{object of class \code{matrix}}
}
\value{
Object of \code{\link{R6Class}} for modelling an GML grid envelope
}
\description{
This method is used to instantiate a GML envelope. The argument 'bbox'
   should be a matrix of dim 2,2 giving the x/y min/max values of a bouding box,
   as returned by \code{bbox} function in package \pkg{sp}
}
\section{Fields}{

\describe{
\item{\code{low}}{[\code{\link{matrix}}]}

\item{\code{high}}{[\code{\link{matrix}}]}
}}

\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{Envelope}
\keyword{GML}
\keyword{Grid}
\keyword{ISO}
