% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOInheritanceRelation.R
\docType{class}
\name{ISOInheritanceRelation}
\alias{ISOInheritanceRelation}
\title{ISOInheritanceRelation}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISOInheritanceRelation
}
\description{
ISOInheritanceRelation
}
\section{Fields}{

\describe{
\item{\code{name}}{[\code{\link{character}}] name}

\item{\code{description}}{[\code{\link{character}}] description}

\item{\code{uniqueInstance}}{[\code{\link{logical}}]}

\item{\code{subtype}}{[\code{\link{ISOFeatureType}}] subtype}

\item{\code{supertype}}{[\code{\link{ISOFeatureType}}] supertype}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml, defaults)}}{
   This method is used to instantiate an \code{\link{ISOInheritanceRelation}}
 }
 \item{\code{setName(name, locales)}}{
   Set name of inheritance relation. Locale names can be specified
    as \code{list} with the \code{locales} argument.
 }
 \item{\code{setDescription(description, locales)}}{
   Set description of inheritance relation. Locale names can be specified
    as \code{list} with the \code{locales} argument.
 }
 \item{\code{setUniqueInstance(uniqueInstance)}}{
   Set \code{TRUE} if it's a unique instance, \code{FALSE} otherwise
 }
 \item{\code{setSubtype(featureType)}}{
   Set subtype, object of class \code{\link{ISOFeatureType}}
 }
 \item{\code{setSupertype(featureType)}}{
   Set supertype, object of class \code{\link{ISOFeatureType}}
 }
}
}

\references{
ISO 19110:2005 Methodology for Feature cataloguing
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{InheritanceRelation}
