% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ISOSource.R
\docType{class}
\name{ISOSource}
\alias{ISOSource}
\title{ISOSource}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an ISO Source
}
\description{
ISOSource
}
\section{Fields}{

\describe{
\item{\code{description}}{[\code{\link{character}}] source description}

\item{\code{scaleDenominator}}{[\code{\link{ISORepresentativeFraction}}] sale denominator}

\item{\code{sourceReferenceSystem}}{[\code{\link{ISOReferenceSystem}}] source reference system}

\item{\code{sourceCitation}}{[\code{\link{ISOCitation}}] the source citation}

\item{\code{sourceExtent}}{[\code{\link{ISOExtent}}] the source extent(s)}

\item{\code{sourceStep}}{[\code{\link{ISOProcessStep}}] the source process step(s)}
}}

\section{Methods}{

\describe{
 \item{\code{new(xml)}}{
   This method is used to instantiate an \code{\link{ISOSource}}
 }
 \item{\code{setDescription(description, locales)}}{
   Sets the source description. Locale names can be specified as \code{list}
   with the \code{locales} argument.
 }
 \item{\code{setScaleDenominator(denominator)}}{
   Sets the scale denominator (object of class \code{\link{ISORepresentativeFraction}} or
   an integer value or other value coercable to integer)
 }
 \item{\code{setReferenceSystem(referenceSystem)}}{
   Sets the source reference system (object of class \code{\link{ISOReferenceSystem}})
 }
 \item{\code{setCitation(citation)}}{
   Sets the source citation (object of class \code{\link{ISOCitation}})
 }
 \item{\code{addExtent(extent)}}{
   Adds the source extent (object of class \code{\link{ISOExtent}})
 }
 \item{\code{delExtent(extent)}}{
   Deletes a source extent (object of class \code{\link{ISOExtent}})
 }
 \item{\code{addProcessStep(processStep)}}{
   Adds a source process step (object of class \code{\link{ISOProcessStep}})
 }
 \item{\code{delProcessStep(processStep)}}{
   Deletes a source processStep(object of class \code{\link{ISOProcessStep}})
 }
}
}

\examples{
  src <- ISOSource$new()
  src$setDescription("description")
  src$setScaleDenominator(1L)
  
  rs <- ISOReferenceSystem$new()
  rsId <- ISOReferenceIdentifier$new(code = "4326", codeSpace = "EPSG")
  rs$setReferenceSystemIdentifier(rsId)
  src$setReferenceSystem(rs)
  
  cit <- ISOCitation$new()
  cit$setTitle("sometitle") #and more citation properties...
  src$setCitation(cit)
  
  extent <- ISOExtent$new()
  bbox <- ISOGeographicBoundingBox$new(minx = -180, miny = -90, maxx = 180, maxy = 90)
  extent$setGeographicElement(bbox)
  src$addExtent(extent)
  xml <- src$encode()
  
}
\references{
ISO 19115:2003 - Geographic information -- Metadata
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{ISO}
\keyword{source}
