% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMLAbstractCoordinateOperation.R
\docType{class}
\name{GMLAbstractCoordinateOperation}
\alias{GMLAbstractCoordinateOperation}
\title{GMLAbstractCoordinateOperation}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an GMLAbstractCoordinateOperation
}
\description{
GMLAbstractCoordinateOperation

GMLAbstractCoordinateOperation
}
\references{
ISO 19136:2007 Geographic Information -- Geographic Markup Language.
  http://www.iso.org/iso/iso_catalogue/catalogue_tc/catalogue_detail.htm?csnumber=32554 
  
  OGC Geography Markup Language. http://www.opengeospatial.org/standards/gml
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{GML}
\keyword{ISO}
\keyword{Operation}
\keyword{abstract}
\keyword{coordinate}
\section{Super classes}{
\code{\link[geometa:geometaLogger]{geometa::geometaLogger}} -> \code{\link[geometa:ISOAbstractObject]{geometa::ISOAbstractObject}} -> \code{\link[geometa:GMLAbstractObject]{geometa::GMLAbstractObject}} -> \code{\link[geometa:GMLAbstractGML]{geometa::GMLAbstractGML}} -> \code{\link[geometa:GMLDefinition]{geometa::GMLDefinition}} -> \code{GMLAbstractCoordinateOperation}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{domainOfValidity}}{domainOfValidity [0..1]: character}

\item{\code{scope}}{scope [1..*]: character}

\item{\code{operationVersion}}{operationVersion [0..1]: character}

\item{\code{coordinateOperationAccuracy}}{coordinateOperationAccuracy [0..1]: ISOPositionalAccuracy}

\item{\code{sourceCRS}}{sourceCRS [0..1]: subclass of GMLAbstractCRS}

\item{\code{targetCRS}}{targetCRS [0..1]: subclass of GMLAbstractCRS}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GMLAbstractCoordinateOperation-new}{\code{GMLAbstractCoordinateOperation$new()}}
\item \href{#method-GMLAbstractCoordinateOperation-setDomainOfValidity}{\code{GMLAbstractCoordinateOperation$setDomainOfValidity()}}
\item \href{#method-GMLAbstractCoordinateOperation-addScope}{\code{GMLAbstractCoordinateOperation$addScope()}}
\item \href{#method-GMLAbstractCoordinateOperation-delScope}{\code{GMLAbstractCoordinateOperation$delScope()}}
\item \href{#method-GMLAbstractCoordinateOperation-setVersion}{\code{GMLAbstractCoordinateOperation$setVersion()}}
\item \href{#method-GMLAbstractCoordinateOperation-addAccuracy}{\code{GMLAbstractCoordinateOperation$addAccuracy()}}
\item \href{#method-GMLAbstractCoordinateOperation-delAccuracy}{\code{GMLAbstractCoordinateOperation$delAccuracy()}}
\item \href{#method-GMLAbstractCoordinateOperation-setSourceCRS}{\code{GMLAbstractCoordinateOperation$setSourceCRS()}}
\item \href{#method-GMLAbstractCoordinateOperation-setTargetCRS}{\code{GMLAbstractCoordinateOperation$setTargetCRS()}}
\item \href{#method-GMLAbstractCoordinateOperation-clone}{\code{GMLAbstractCoordinateOperation$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="ERROR"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-ERROR'><code>geometa::geometaLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="INFO"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-INFO'><code>geometa::geometaLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="geometaLogger" data-id="WARN"><a href='../../geometa/html/geometaLogger.html#method-geometaLogger-WARN'><code>geometa::geometaLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addFieldAttrs"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addFieldAttrs'><code>geometa::ISOAbstractObject$addFieldAttrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="addListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-addListElement'><code>geometa::ISOAbstractObject$addListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="contains"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-contains'><code>geometa::ISOAbstractObject$contains()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="createLocalisedProperty"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-createLocalisedProperty'><code>geometa::ISOAbstractObject$createLocalisedProperty()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="decode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-decode'><code>geometa::ISOAbstractObject$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="delListElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-delListElement'><code>geometa::ISOAbstractObject$delListElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="encode"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-encode'><code>geometa::ISOAbstractObject$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClass"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClass'><code>geometa::ISOAbstractObject$getClass()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getClassName"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getClassName'><code>geometa::ISOAbstractObject$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="getNamespaceDefinition"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-getNamespaceDefinition'><code>geometa::ISOAbstractObject$getNamespaceDefinition()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isDocument"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isDocument'><code>geometa::ISOAbstractObject$isDocument()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="isFieldInheritedFrom"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-isFieldInheritedFrom'><code>geometa::ISOAbstractObject$isFieldInheritedFrom()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="print"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-print'><code>geometa::ISOAbstractObject$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="save"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-save'><code>geometa::ISOAbstractObject$save()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setAttr"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setAttr'><code>geometa::ISOAbstractObject$setAttr()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeList"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeList'><code>geometa::ISOAbstractObject$setCodeList()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeListValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeListValue'><code>geometa::ISOAbstractObject$setCodeListValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setCodeSpace"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setCodeSpace'><code>geometa::ISOAbstractObject$setCodeSpace()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setHref"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setHref'><code>geometa::ISOAbstractObject$setHref()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setId"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setId'><code>geometa::ISOAbstractObject$setId()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setIsNull"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setIsNull'><code>geometa::ISOAbstractObject$setIsNull()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="setValue"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-setValue'><code>geometa::ISOAbstractObject$setValue()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="validate"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-validate'><code>geometa::ISOAbstractObject$validate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="ISOAbstractObject" data-id="wrapBaseElement"><a href='../../geometa/html/ISOAbstractObject.html#method-ISOAbstractObject-wrapBaseElement'><code>geometa::ISOAbstractObject$wrapBaseElement()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractGML" data-id="addName"><a href='../../geometa/html/GMLAbstractGML.html#method-GMLAbstractGML-addName'><code>geometa::GMLAbstractGML$addName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractGML" data-id="delName"><a href='../../geometa/html/GMLAbstractGML.html#method-GMLAbstractGML-delName'><code>geometa::GMLAbstractGML$delName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractGML" data-id="setDescription"><a href='../../geometa/html/GMLAbstractGML.html#method-GMLAbstractGML-setDescription'><code>geometa::GMLAbstractGML$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractGML" data-id="setDescriptionReference"><a href='../../geometa/html/GMLAbstractGML.html#method-GMLAbstractGML-setDescriptionReference'><code>geometa::GMLAbstractGML$setDescriptionReference()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLAbstractGML" data-id="setIdentifier"><a href='../../geometa/html/GMLAbstractGML.html#method-GMLAbstractGML-setIdentifier'><code>geometa::GMLAbstractGML$setIdentifier()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLDefinition" data-id="addRemark"><a href='../../geometa/html/GMLDefinition.html#method-GMLDefinition-addRemark'><code>geometa::GMLDefinition$addRemark()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geometa" data-topic="GMLDefinition" data-id="delRemark"><a href='../../geometa/html/GMLDefinition.html#method-GMLDefinition-delRemark'><code>geometa::GMLDefinition$delRemark()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-new"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-new}{}}}
\subsection{Method \code{new()}}{
Initializes object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$new(xml = NULL, defaults = list(), id = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}

\item{\code{defaults}}{list of default values}

\item{\code{id}}{id}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-setDomainOfValidity"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-setDomainOfValidity}{}}}
\subsection{Method \code{setDomainOfValidity()}}{
Set domain of validity
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$setDomainOfValidity(domainOfValidity)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{domainOfValidity}}{domain of validity, object extending \link{ISOExtent} class}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-addScope"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-addScope}{}}}
\subsection{Method \code{addScope()}}{
Adds scope
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$addScope(scope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{scope}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-delScope"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-delScope}{}}}
\subsection{Method \code{delScope()}}{
Removes scope
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$delScope(scope)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{scope}}{scope}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-setVersion"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-setVersion}{}}}
\subsection{Method \code{setVersion()}}{
Set version
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$setVersion(version)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{version}}{version}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-addAccuracy"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-addAccuracy}{}}}
\subsection{Method \code{addAccuracy()}}{
Adds accuracy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$addAccuracy(accuracy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accuracy}}{accuracy, object inheriting class \link{ISOAbstractPositionalAccuracy}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-delAccuracy"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-delAccuracy}{}}}
\subsection{Method \code{delAccuracy()}}{
Removes accuracy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$delAccuracy(accuracy)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{accuracy}}{accuracy, object inheriting class \link{ISOAbstractPositionalAccuracy}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if removed, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-setSourceCRS"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-setSourceCRS}{}}}
\subsection{Method \code{setSourceCRS()}}{
Set source CRS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$setSourceCRS(crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{crs}}{crs, object inheriting class \link{GMLAbstractSingleCRS}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-setTargetCRS"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-setTargetCRS}{}}}
\subsection{Method \code{setTargetCRS()}}{
Set target CRS
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$setTargetCRS(crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{crs}}{crs, object inheriting class \link{GMLAbstractSingleCRS}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GMLAbstractCoordinateOperation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GMLAbstractCoordinateOperation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GMLAbstractCoordinateOperation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
