% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readmulti.nts.r
\name{readmulti.nts}
\alias{readmulti.nts}
\title{Read and combine multiple nts files}
\usage{
readmulti.nts(filelist)
}
\arguments{
\item{filelist}{A vector containing the file paths to all the nts files to be compiled}
}
\value{
Function returns a 3D array (p x k x n), where p is the number of landmark points, k is 
  the number of landmark dimensions (2 or 3), and n is the number of specimens. The third dimension 
  of this array contains names for each specimen, which are retrieved from the nts specimen labels, 
  if those are available. Specimens in nts files without labels are named as filename_# where # are consecutive
  numbers.
}
\description{
Read multiple nts (or .dta) files to obtain landmark coordinates and combine them into a single array
}
\details{
This is a wrapper of \code{\link{readland.nts}} to allow reading landmark coordinates, in 2D or 3D, 
from several nts (or .dta) files, and compiling them into an array for proceeding with GM procedures.

See \code{\link{readland.nts}} for adequately formatting NTS files and requirements that need to be met 
for that (and therefore this) function to work correctly.
}
\references{
Rohlf, F. J. 2012 NTSYSpc: Numerical taxonomy and multivariate analysis system. Version 
  2.2. Exeter Software, New York.
}
\author{
Antigoni Kaliontzopoulou
}
