% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomorph.data.frame.r
\name{geomorph.data.frame}
\alias{geomorph.data.frame}
\title{Create a data frame with shape data}
\usage{
geomorph.data.frame(...)
}
\arguments{
\item{...}{a list of objects to include in the data frame.}
}
\description{
A list similar to a data frame to facilitate analysis of shape data.
}
\details{
This function produces a list that can be used like a data frame in other analytical functions.
The purpose is similar to the function, \code{\link[base]{data.frame}}, but without the constraint that 
data must conform to an n (observations) x p (variables) matrix.  Rather, the list produced is 
constrained only by n.  List objects can be Procrustes shape variables, matrices, variables,
distance matrices, and phylogenetic trees.  Results from \code{\link{gpagen}} can be directly
imported into a geomorph.data.frame to utilize the coordinates and centroid size as variables. (See Examples)
}
\examples{
\dontrun{
data(plethodon) 
Y.gpa <- gpagen(plethodon$land, PrinAxes = FALSE)
gdf <- geomorph.data.frame(Y.gpa)
attributes(gdf)

gdf <- geomorph.data.frame(Y.gpa, species = plethodon$species, 
site = plethodon$site)
attributes(gdf)

# Using geomorph.data.frame to facilitate analysis
anova(procD.lm(coords ~ Csize + species * site, data = gdf))
}
}
\author{
Michael Collyer
}
\keyword{utilities}
