% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSFeatureType.R
\docType{class}
\name{GSFeatureType}
\alias{GSFeatureType}
\title{A GeoServer feature type}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer feature type
}
\description{
This class models a GeoServer feature type. This class is to be
used for manipulating representations of vector data with GeoServer.
}
\details{
Geoserver REST API Resource
}
\examples{
  ft <- GSFeatureType$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{featureType}
\keyword{geoserver}
\keyword{resource}
\keyword{rest}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSResource]{geosapi::GSResource}} -> \code{GSFeatureType}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{cqlFilter}}{CQL filter}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSFeatureType-new}{\code{GSFeatureType$new()}}
\item \href{#method-GSFeatureType-decode}{\code{GSFeatureType$decode()}}
\item \href{#method-GSFeatureType-setCqlFilter}{\code{GSFeatureType$setCqlFilter()}}
\item \href{#method-GSFeatureType-setVirtualTable}{\code{GSFeatureType$setVirtualTable()}}
\item \href{#method-GSFeatureType-delVirtualTable}{\code{GSFeatureType$delVirtualTable()}}
\item \href{#method-GSFeatureType-clone}{\code{GSFeatureType$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="addKeyword"><a href='../../geosapi/html/GSResource.html#method-GSResource-addKeyword'><code>geosapi::GSResource$addKeyword()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="addMetadataLink"><a href='../../geosapi/html/GSResource.html#method-GSResource-addMetadataLink'><code>geosapi::GSResource$addMetadataLink()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="delKeyword"><a href='../../geosapi/html/GSResource.html#method-GSResource-delKeyword'><code>geosapi::GSResource$delKeyword()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="delMetadata"><a href='../../geosapi/html/GSResource.html#method-GSResource-delMetadata'><code>geosapi::GSResource$delMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="deleteMetadataLink"><a href='../../geosapi/html/GSResource.html#method-GSResource-deleteMetadataLink'><code>geosapi::GSResource$deleteMetadataLink()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setAbstract"><a href='../../geosapi/html/GSResource.html#method-GSResource-setAbstract'><code>geosapi::GSResource$setAbstract()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setDescription"><a href='../../geosapi/html/GSResource.html#method-GSResource-setDescription'><code>geosapi::GSResource$setDescription()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setEnabled"><a href='../../geosapi/html/GSResource.html#method-GSResource-setEnabled'><code>geosapi::GSResource$setEnabled()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setKeywords"><a href='../../geosapi/html/GSResource.html#method-GSResource-setKeywords'><code>geosapi::GSResource$setKeywords()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setLatLonBoundingBox"><a href='../../geosapi/html/GSResource.html#method-GSResource-setLatLonBoundingBox'><code>geosapi::GSResource$setLatLonBoundingBox()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setMetadata"><a href='../../geosapi/html/GSResource.html#method-GSResource-setMetadata'><code>geosapi::GSResource$setMetadata()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setMetadataDimension"><a href='../../geosapi/html/GSResource.html#method-GSResource-setMetadataDimension'><code>geosapi::GSResource$setMetadataDimension()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setMetadataLinks"><a href='../../geosapi/html/GSResource.html#method-GSResource-setMetadataLinks'><code>geosapi::GSResource$setMetadataLinks()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setName"><a href='../../geosapi/html/GSResource.html#method-GSResource-setName'><code>geosapi::GSResource$setName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setNativeBoundingBox"><a href='../../geosapi/html/GSResource.html#method-GSResource-setNativeBoundingBox'><code>geosapi::GSResource$setNativeBoundingBox()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setNativeCRS"><a href='../../geosapi/html/GSResource.html#method-GSResource-setNativeCRS'><code>geosapi::GSResource$setNativeCRS()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setNativeName"><a href='../../geosapi/html/GSResource.html#method-GSResource-setNativeName'><code>geosapi::GSResource$setNativeName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setProjectionPolicy"><a href='../../geosapi/html/GSResource.html#method-GSResource-setProjectionPolicy'><code>geosapi::GSResource$setProjectionPolicy()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setSrs"><a href='../../geosapi/html/GSResource.html#method-GSResource-setSrs'><code>geosapi::GSResource$setSrs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSResource" data-id="setTitle"><a href='../../geosapi/html/GSResource.html#method-GSResource-setTitle'><code>geosapi::GSResource$setTitle()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSFeatureType-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSFeatureType-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSFeatureType}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSFeatureType$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSFeatureType-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSFeatureType-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSFeatureType$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSFeatureType-setCqlFilter"></a>}}
\if{latex}{\out{\hypertarget{method-GSFeatureType-setCqlFilter}{}}}
\subsection{Method \code{setCqlFilter()}}{
Set CQL filter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSFeatureType$setCqlFilter(cqlFilter)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cqlFilter}}{CQL filter}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSFeatureType-setVirtualTable"></a>}}
\if{latex}{\out{\hypertarget{method-GSFeatureType-setVirtualTable}{}}}
\subsection{Method \code{setVirtualTable()}}{
Set virtual table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSFeatureType$setVirtualTable(vt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vt}}{object of class \link{GSVirtualTable}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if set/added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSFeatureType-delVirtualTable"></a>}}
\if{latex}{\out{\hypertarget{method-GSFeatureType-delVirtualTable}{}}}
\subsection{Method \code{delVirtualTable()}}{
Deletes virtual table
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSFeatureType$delVirtualTable()}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{vt}}{object of class \link{GSVirtualTable}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSFeatureType-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSFeatureType-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSFeatureType$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
