% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSLayerGroup.R
\docType{class}
\name{GSLayerGroup}
\alias{GSLayerGroup}
\title{A GeoServer layergroup resource}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling a GeoServer layergroup
}
\description{
This class models a GeoServer layer group. This class is to be
used for clustering layers into a group.
}
\details{
Geoserver REST API LayerGroup
}
\examples{
  lyr <- GSLayerGroup$new()

}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{api}
\keyword{coverage}
\keyword{featureType}
\keyword{geoserver}
\keyword{group}
\keyword{layer}
\keyword{resource}
\keyword{rest}
\section{Super class}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{GSLayerGroup}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{full}}{full}

\item{\code{name}}{name}

\item{\code{mode}}{mode}

\item{\code{title}}{title}

\item{\code{abstractTxt}}{abstract}

\item{\code{workspace}}{workspace}

\item{\code{publishables}}{publishables}

\item{\code{styles}}{styles}

\item{\code{metadataLinks}}{metadata links}

\item{\code{bounds}}{bounds}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSLayerGroup-new}{\code{GSLayerGroup$new()}}
\item \href{#method-GSLayerGroup-decode}{\code{GSLayerGroup$decode()}}
\item \href{#method-GSLayerGroup-setName}{\code{GSLayerGroup$setName()}}
\item \href{#method-GSLayerGroup-setMode}{\code{GSLayerGroup$setMode()}}
\item \href{#method-GSLayerGroup-setTitle}{\code{GSLayerGroup$setTitle()}}
\item \href{#method-GSLayerGroup-setAbstract}{\code{GSLayerGroup$setAbstract()}}
\item \href{#method-GSLayerGroup-setWorkspace}{\code{GSLayerGroup$setWorkspace()}}
\item \href{#method-GSLayerGroup-addLayer}{\code{GSLayerGroup$addLayer()}}
\item \href{#method-GSLayerGroup-addLayerGroup}{\code{GSLayerGroup$addLayerGroup()}}
\item \href{#method-GSLayerGroup-addPublishable}{\code{GSLayerGroup$addPublishable()}}
\item \href{#method-GSLayerGroup-setStyles}{\code{GSLayerGroup$setStyles()}}
\item \href{#method-GSLayerGroup-addStyle}{\code{GSLayerGroup$addStyle()}}
\item \href{#method-GSLayerGroup-setMetadataLinks}{\code{GSLayerGroup$setMetadataLinks()}}
\item \href{#method-GSLayerGroup-addMetadataLink}{\code{GSLayerGroup$addMetadataLink()}}
\item \href{#method-GSLayerGroup-deleteMetadataLink}{\code{GSLayerGroup$deleteMetadataLink()}}
\item \href{#method-GSLayerGroup-setBounds}{\code{GSLayerGroup$setBounds()}}
\item \href{#method-GSLayerGroup-clone}{\code{GSLayerGroup$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="encode"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-encode'><code>geosapi::GSRESTResource$encode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{GSLayerGroup}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$new(xml = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-decode"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes from XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{xml_node-class}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setName"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setName}{}}}
\subsection{Method \code{setName()}}{
Set name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setName(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setMode"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setMode}{}}}
\subsection{Method \code{setMode()}}{
Set mode
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setMode(mode)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mode}}{a mode value among "SINGLE", "NAMED", "CONTAINER", "EO"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setTitle"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setTitle}{}}}
\subsection{Method \code{setTitle()}}{
Set title
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setTitle(title)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{title}}{title}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setAbstract"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setAbstract}{}}}
\subsection{Method \code{setAbstract()}}{
Set abstract
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setAbstract(abstract)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{abstract}}{abstract}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setWorkspace"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setWorkspace}{}}}
\subsection{Method \code{setWorkspace()}}{
Set workspace
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setWorkspace(workspace)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{workspace}}{workspace name, object of class \link{GSWorkspace} or \code{character}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-addLayer"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-addLayer}{}}}
\subsection{Method \code{addLayer()}}{
Adds layer
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$addLayer(layer, style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layer}}{layer name}

\item{\code{style}}{style name}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-addLayerGroup"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-addLayerGroup}{}}}
\subsection{Method \code{addLayerGroup()}}{
Adds layer group
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$addLayerGroup(layerGroup)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{layerGroup}}{layer group}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-addPublishable"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-addPublishable}{}}}
\subsection{Method \code{addPublishable()}}{
Adds publishable
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$addPublishable(publishable)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{publishable}}{publishable}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setStyles"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setStyles}{}}}
\subsection{Method \code{setStyles()}}{
Set styles
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setStyles(styles)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{styles}}{styles}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-addStyle"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-addStyle}{}}}
\subsection{Method \code{addStyle()}}{
Adds a style
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$addStyle(style)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{style}}{style}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setMetadataLinks"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setMetadataLinks}{}}}
\subsection{Method \code{setMetadataLinks()}}{
Set metadata links
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setMetadataLinks(metadataLinks)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLinks}}{metadata links}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-addMetadataLink"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-addMetadataLink}{}}}
\subsection{Method \code{addMetadataLink()}}{
Adds metadata link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$addMetadataLink(metadataLink)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLink}}{object of class \link{GSMetadataLink}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-deleteMetadataLink"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-deleteMetadataLink}{}}}
\subsection{Method \code{deleteMetadataLink()}}{
Deletes metadata link
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$deleteMetadataLink(metadataLink)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metadataLink}}{object of class \link{GSMetadataLink}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-setBounds"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-setBounds}{}}}
\subsection{Method \code{setBounds()}}{
Set bounds
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$setBounds(minx, miny, maxx, maxy, bbox = NULL, crs)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{minx}}{minx}

\item{\code{miny}}{miny}

\item{\code{maxx}}{maxx}

\item{\code{maxy}}{maxy}

\item{\code{bbox}}{bbox}

\item{\code{crs}}{crs}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSLayerGroup-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSLayerGroup-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSLayerGroup$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
