% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randKmapGrid.R
\name{randKmapGrid}
\alias{randKmapGrid}
\title{randKmapGrid}
\usage{
randKmapGrid(DataObj, nSimuCond = 0, boundary = list(x = c(0, 0, 1, 1, 0), y
  = c(0, 1, 1, 0, 0)), manualBoundary = FALSE, disp = 0, FULL = FALSE)
}
\arguments{
\item{DataObj}{=NULL: simulated data with seed or = a data frame with real data}

\item{nSimuCond}{numeric}

\item{boundary}{list contains x and y}

\item{manualBoundary}{logical, default FALSE}

\item{disp}{numeric}

\item{FULL}{logical, if TRUE the returned list is complete}
}
\value{
a list
\describe{
\item{rawData}{simulated or real raw data within the boundary}
\item{step}{grid step}
\item{krigData}{kriged data}
\item{krigGrid}{kriged data in form of grid}
\item{krigN}{kriged neighbours of each data point}
\item{krigSurfVoronoi}{areas of Voronoi polygons in the tesselation of kriged data}
\item{modelGen}{random fields model}
\item{VGMmodel}{vgm model}
\item{boundary}{(x,y) list of boundary points}
}
}
\description{
randKmapGrid
}
\details{
Prepare real data for zoning, data are already on a regular grid, hence no kriging is done.
}
\examples{
\donttest{
data(dataReg) #regular data on a square grid between 0 and 1
map = randKmapGrid(dataReg)
plotMap(map)
}
}
