% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bookinst_bib.R
\name{bookinst_bib}
\alias{bookinst_bib}
\title{Function for preparing institutional book metadata for automatic insertion into scientific articles}
\usage{
bookinst_bib(input_date, input_tam)
}
\arguments{
\item{input_date}{is a dataframe with the scientific production database in the form of a institutional books}

\item{input_tam}{is the length of the dataframe with the institutional books, obtained using package bibliorefer.}
}
\value{
The output of the bookinst_bib function is the file with the .bib extension of institutional books in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\description{
The bookinst_bib function prepares the metadata of institutional books to be automatically included in a scientific article. The bookinst_bib function internally calls two support functions. The output of the bookinst_bib function is the file with the .bib extension of institutional books in BibTex format, prepared to be automatically included in the reference list of a scientific article.
}
\examples{

# Example

# File of database
file_db <- system.file("extdata","compinst.csv", package = "gerefer")
separator <- ";"

# Parameters of the function
input_date <- example_database(file_db, separator)
input_tam <- 5

#Calls the function bookcap_bib
bookinstlister_bibtex <- bookinst_bib(input_date, input_tam)
bookinstlister_bibtex


}
\references{
1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
}
