% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPass.r
\name{getPass}
\alias{getPass}
\title{Password Input}
\usage{
getPass(msg = "PASSWORD: ", forcemask = FALSE)
}
\arguments{
\item{msg}{The message to enter into the R session before prompting
for the masked input.  This can be any single string,
including a "blank", namely \code{""}.}

\item{forcemask}{Logical; should the function stop with an error if masking
is not supported? If \code{FALSE}, the function will default
to use \code{readline()} with a warning message that the
input is not masked, and otherwise will stop with an error.}
}
\value{
If input is provided, then that is returned. If the user cancels
(e.g., cancel button on RStudio or ctrl+c in the terminal), then
\code{NULL} is returned.
}
\description{
Masked user input (where supported; see details section for more
information).  Useful for reading in passwords.
}
\details{
Masking (i.e., not displaying the literal typed text
as input) is supported on most, but not all
platforms.  It is supported in RStudio, provided you
have a suitable version of the GUI.  It should also work in the
terminal on any major OS.  Finally, it will work in any environment
where the tcltk package is available.

In the terminal, the maximum length for input is 200 characters.
Additionally, messages printed to the terminal (including the 
"*" masking) are printed to stderr.
}
\examples{
\dontrun{
getPass::getPass()
getPass::getPass("Enter the password: ")
}

}

