% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pvol.R
\name{get_pvol}
\alias{get_pvol}
\title{Get polar volume (PVOL) data from supported sources}
\usage{
get_pvol(radar = NULL, datetime = NULL, ...)
}
\arguments{
\item{radar}{Name of the radar (odim code) as a character string (e.g.
\code{"nlhrw"} or \code{"fikor"}).}

\item{datetime}{Either:
\itemize{
\item A single \code{\link[base:DateTimeClasses]{POSIXct}}, for which the most
representative data file is downloaded. In most cases this will be the time
before.
\item A \code{\link[lubridate:interval]{lubridate::interval()}} or two \code{\link[base:DateTimeClasses]{POSIXct}},
between which all data files are downloaded.
}}

\item{...}{Additional arguments passed on to reading functions, for example
\code{param = "all"} to the \code{\link[bioRad:read_pvolfile]{bioRad::read_pvolfile()}}.}
}
\value{
Either a polar volume or a list of polar volumes. See
\code{\link[bioRad:summary.pvol]{bioRad::summary.pvol()}} for details.
}
\description{
Gets polar volume data from supported sources and returns it as a (list of)
\link[bioRad:summary.pvol]{polar volume objects}. The source is automatically
detected based on the provided \code{radar}.
}
\details{
For more details on supported sources, see \code{vignette("supported_sources")}. Within
supported countries there might also be temporal restrictions on the radars that
are operational. For example, radars with the \code{status} \code{0} in \code{get_weather_radars("opera")}
are currently not operational.

Not all radars in the nexrad archive can be read successfully. Radars associated
with the Terminal Doppler Weather Radar (TDWR) program can not be read. These can
be identified using the \code{stntype} column in \code{get_weather_radars("nexrad")}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get PVOL data for a single radar and datetime
get_pvol("deess", as.POSIXct(Sys.Date()))

# Get PVOL data for multiple radars and a single datetime
get_pvol(
  c("deess", "dehnr", "fianj", "czska", "KABR"),
  as.POSIXct(Sys.Date())
)
\dontshow{\}) # examplesIf}
}
