% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vpts_aloft.R
\name{get_vpts_aloft}
\alias{get_vpts_aloft}
\title{Get VPTS data from the Aloft bucket}
\usage{
get_vpts_aloft(
  radar_odim_code,
  rounded_interval,
  source = c("baltrad", "uva", "ecog-04003"),
  coverage = get_vpts_coverage_aloft()
)
}
\arguments{
\item{radar_odim_code}{Radar ODIM code.}

\item{rounded_interval}{Interval to fetch data for, rounded to nearest day.}

\item{source}{Source of the data. One of \code{baltrad}, \code{uva} or \code{ecog-04003}.}

\item{coverage}{A data frame containing the coverage of the Aloft bucket.
If not provided, it will be fetched from via the internet.}
}
\value{
A tibble with VPTS data.
}
\description{
Gets VPTS data from the Aloft bucket.
}
\details{
By default, data from the \href{https://aloftdata.eu/browse/}{Aloft bucket} are
retrieved from \url{https://aloftdata.s3-eu-west-1.amazonaws.com}. This can be changed by
setting \code{options(getRad.aloft_data_url)} to any desired url.
}
\section{Inner working}{

\itemize{
\item Constructs the S3 paths for the VPTS files based on the input.
\item Performs parallel HTTP requests to fetch the VPTS CSV data.
\item Parses the response bodies with some assumptions about the column classes.
\item Adds a column with the radar source.
\item Overwrites the radar column with the radar_odim_code, all other values for
this column are considered in error.
}
}

\keyword{internal}
