% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shh.R
\name{shh_markTrustedPeer}
\alias{shh_markTrustedPeer}
\title{Indication of trusted peers.}
\usage{
shh_markTrustedPeer(enode)
}
\arguments{
\item{enode}{String - Enode of the trusted peer.}
}
\value{
Boolean - \code{true} on success.
}
\description{
\code{shh_markTrustedPeer} marks specific peer trusted, which will allow it
to send historic (expired) messages.
}
\examples{
\donttest{
shh_markTrustedPeer('enode://c1a07558238c0b31657450dd34a558752d63150ce334f3
e99b9187262b612f48a713a083cd1601bfe3bba761a908264320885633fa81d6d6ca0ef7a6e
84a2bcd@127.0.0.1:30301')
}

}
\seealso{
Other shh functions: \code{\link{gethr}},
  \code{\link{shh_addPrivatekey}},
  \code{\link{shh_addSymKey}},
  \code{\link{shh_deleteKeyPair}},
  \code{\link{shh_deleteSymKey}},
  \code{\link{shh_generateSymKeyFromPassword}},
  \code{\link{shh_getPrivateKey}},
  \code{\link{shh_getPublicKey}},
  \code{\link{shh_getSymKey}},
  \code{\link{shh_hasKeyPair}},
  \code{\link{shh_hasSymKey}}, \code{\link{shh_info}},
  \code{\link{shh_newKeyPair}},
  \code{\link{shh_newMessageFilter}},
  \code{\link{shh_newSymKey}}, \code{\link{shh_post}},
  \code{\link{shh_setMaxMessageSize}},
  \code{\link{shh_setMinPoW}}, \code{\link{shh_version}}
}
\concept{shh functions}
