% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shh.R
\name{shh_newMessageFilter}
\alias{shh_newMessageFilter}
\title{New filter in the node.}
\usage{
shh_newMessageFilter(symKeyID = NULL, privateKeyID = NULL,
  sig = NULL, minPow = NULL, topics = NULL, allowP2P = NULL)
}
\arguments{
\item{symKeyID}{String - ID of the symmetric key for message decryption.}

\item{privateKeyID}{String - ID of the key pair for message decryption.}

\item{sig}{String - Public key of the signature.}

\item{minPow}{Integer - Minimal PoW requirement for incomming messages.}

\item{topics}{Array of Data - Possible topics (or partial topics).}

\item{allowP2P}{Boolean - Indicates if this filter allows processing of
direct peer-to-peer messages (which are not to be forwarded any further,
because they might be expired).}
}
\value{
String - Filter identifier.
}
\description{
\code{shh_newMessageFilter} create a new filter within the node. This filter
can be used to poll for new messages that match the set of criteria.
}
\examples{
\donttest{
shh_newMessageFilter(symKeyID = '8e975ab6e0427396d3afb748678a09b036ebe389
c1c5a6d39560adabdfdb08ca')
shh_newMessageFilter(privateKeyID = '3794e3b08a2962b066e19869283974dc6b39
6cfc87cdcd69a2d269f5f1bab3cb', minPow = 0.3, allowP2P = TRUE)
}

}
\seealso{
Other shh functions: \code{\link{gethr}},
  \code{\link{shh_addPrivatekey}},
  \code{\link{shh_addSymKey}},
  \code{\link{shh_deleteKeyPair}},
  \code{\link{shh_deleteSymKey}},
  \code{\link{shh_generateSymKeyFromPassword}},
  \code{\link{shh_getPrivateKey}},
  \code{\link{shh_getPublicKey}},
  \code{\link{shh_getSymKey}},
  \code{\link{shh_hasKeyPair}},
  \code{\link{shh_hasSymKey}}, \code{\link{shh_info}},
  \code{\link{shh_markTrustedPeer}},
  \code{\link{shh_newKeyPair}},
  \code{\link{shh_newSymKey}}, \code{\link{shh_post}},
  \code{\link{shh_setMaxMessageSize}},
  \code{\link{shh_setMinPoW}}, \code{\link{shh_version}}
}
\concept{shh functions}
