% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsat_image.R
\name{lsat_image}
\alias{lsat_image}
\title{GET Landsat image(s)}
\usage{
lsat_image(x, overwrite = FALSE, ...)
}
\arguments{
\item{x}{(character) A file name for a geotif file, will be more general soon.}

\item{overwrite}{(logical) Will only overwrite existing path if \code{TRUE}}

\item{...}{Curl args passed on to \code{\link[httr]{GET}}}
}
\value{
Path to the file, whether found in cache or new file
requested.
}
\description{
GET Landsat image(s)
}
\examples{
\dontrun{
# pass an image name
(res <- lsat_list(max = 40))
tifs <- grep("\\\\.TIF$", res$Key, value = TRUE)
lsat_image(tifs[5])
lsat_image(tifs[6])
lsat_image(tifs[9])

# caching
## requesting an image you already have will return path if found
lsat_image(tifs[5])
}
}
\seealso{
\code{\link{lsat_cache}}
}

