% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isatpanel.R
\name{isatpanel}
\alias{isatpanel}
\title{Panel isat function}
\usage{
isatpanel(
  data = NULL,
  formula = NULL,
  index = NULL,
  effect = c("individual"),
  na.remove = TRUE,
  engine = NULL,
  user.estimator = NULL,
  cluster = "none",
  ar = 0,
  iis = FALSE,
  sis = FALSE,
  jiis = FALSE,
  jsis = FALSE,
  fesis = FALSE,
  csis = FALSE,
  cfesis = FALSE,
  csis_var = colnames(mxreg),
  fesis_id = NULL,
  cfesis_var = colnames(mxreg),
  cfesis_id = NULL,
  plot = FALSE,
  plm_model = "within",
  y = NULL,
  id = NULL,
  time = NULL,
  mxreg = NULL,
  ...
)
}
\arguments{
\item{data}{The input data.frame object.}

\item{formula}{Please specify a formula argument. The dependent variable will be the left-most element, separated by a ~ symbol from the remaining regressors. Note the intercept will always be removed, if effect is not "none" - this means that if any fixed effects are specified, the intercept will always be removed.}

\item{index}{Specify the name of the group and time column in the format c("id", "time").}

\item{effect}{Fixed Effect specification. Possible arguments: "twoways", "individual", "time", or "none".}

\item{na.remove}{remove NAs}

\item{engine}{Estimation function to use. Default is NULL, which uses the default estimation procedure of the gets package. Alternatives are "fixest", "plm", or "felm".}

\item{user.estimator}{Use a user.estimator}

\item{cluster}{cluster Standard Errors at this level. Default is "none". Possible values are: "individual", "time", or "twoways".}

\item{ar}{Autoregressive Term to be included. default is 0.}

\item{iis}{use Impulse Indicator Saturation}

\item{sis}{use Step Indicator Saturation. This is only possible if time fixed effects are not used, as they are collinear otherwise.}

\item{jiis}{use Joint Impulse Indicator Saturation (Outliers are common across all units). This is essentially just a time fixed effect, but this allows selection of FE.}

\item{jsis}{use Join Step Indicator Saturation (steps are common across all units)}

\item{fesis}{Fixed Effect Step Indicator Saturation. Constructed by multiplying a constant (1) with group Fixed Effects. Default is FALSE.}

\item{csis}{Coefficient Step Indicator Saturation. Constructed by Default is FALSE.}

\item{cfesis}{Coefficient-Fixed Effect Indicator Saturation. Default is FALSE.}

\item{csis_var}{The csis method can be conducted for all (default) variables or just a subset of them. If you want to use a subset, please specify the column names of the variable in a character vector.}

\item{fesis_id}{The fesis method can be conducted for all (default) individuals/units (i.e. looking for breaks in individual countries) or just a subset of them (joint breaks in the coefficients for a few individuals). If you want to use a subset, please specify the individuals/units for which you want to test the stability in a character vector.}

\item{cfesis_var}{The cfesis method can be conducted for all variables (default) or just a subset of them. If you want to use a subset, please specify the column names of the variable in a character vector.}

\item{cfesis_id}{The cfesis method can be conducted for all individuals/units (default) or just a subset of them. If you want to use a subset, please specify the individuals/units to be tested in a character vector.}

\item{plot}{Logical. Should the final object be plotted? Default is FALSE.}

\item{plm_model}{Type of PLM model (only if engine = "PLM")}

\item{y}{Deprecated. The dependent variable. Can be used when data, index, and formula are not specified.}

\item{id}{Deprecated. Can be used when data, index, and formula are not specified. Must be a vector of the grouping variable as a character or factor}

\item{time}{Deprecated. Can be used when data, index, and formula are not specified. Must be a vector of the time variable as an integer or numeric.}

\item{mxreg}{The co-variates matrix}

\item{...}{Further arguments to gets::isat()}
}
\value{
A list with class 'isatpanel'.
}
\description{
Panel isat function
}
\examples{
\donttest{
data(EU_emissions_road)

# Group specification
EU15 <- c("Austria", "Germany", "Denmark", "Spain", "Finland", "Belgium",
         "France", "United Kingdom", "Ireland", "Italy", "Luxembourg",
         "Netherlands", "Greece", "Portugal", "Sweden")

# Prepare sample and data
EU_emissions_road_short <- EU_emissions_road[
EU_emissions_road$country \%in\% EU15 &
EU_emissions_road$year >= 2000,
]

# Run
result <- isatpanel(
  data = EU_emissions_road_short,
  formula = ltransport.emissions ~ lgdp + I(lgdp^2) + lpop,
  index = c("country", "year"),
  effect = "twoways",
  fesis = TRUE,
  plot = FALSE,
  t.pval = 0.01
)
plot(result)
plot_grid(result)
}
}
\references{
Felix Pretis and Moritz Schwarz (2022). Discovering What Mattered: Answering Reverse Causal Questions by Detecting Unknown Treatment Assignment and Timing as Breaks in Panel Models. January 31, 2022. Available at SSRN: https://ssrn.com/abstract=4022745 or http://dx.doi.org/10.2139/ssrn.4022745
}
