% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histories.R
\name{visit_sum}
\alias{visit_sum}
\title{Create Visit Sum Covariate}
\usage{
visit_sum(pool, histvars, time_name, t, id_name, max_visits)
}
\arguments{
\item{pool}{Data table containing all information prior to time \eqn{t} (\eqn{t} noninclusive).}

\item{histvars}{Vector of character strings specifying the names of the variables for which lagged cumulative averages are to
be created.}

\item{time_name}{Character string specifying the name of the time variable in \code{pool}.}

\item{t}{Integer specifying the current time index.}

\item{id_name}{Character string specifying the name of the ID variable in \code{pool}.}

\item{max_visits}{A vector of one or more values denoting the maximum number of times
a binary covariate representing a visit process may be missed before
the individual is censored from the data (in the observed data) or
a visit is forced (in the simulated data). Multiple values exist in the
vector when the modeling of more than covariate is attached to a visit
process.}
}
\value{
No value is returned. The data table \code{pool} is modified in place.
}
\description{
This internal function assists in the implementation of a visit process by creating a covariate,
\code{ts_visit}, that counts the number of visits in the past \code{max_visits} time points. If this
number is greater than 0, then the individual has not missed more than the maximum number
of visits.
}
\keyword{internal}
