% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dna_tools.R
\name{create_image_data}
\alias{create_image_data}
\title{Rasterise a vector of sequences into a numerical dataframe for ggplotting (generic \code{ggDNAvis} helper)}
\usage{
create_image_data(sequences)
}
\arguments{
\item{sequences}{\verb{character vector}. A vector of sequences for plotting, e.g. \code{c("ATCG", "", "GGCGGC", "")}. Each sequence will be plotted left-aligned on a new line.}
}
\value{
\code{dataframe}. Rasterised dataframe representation of the sequences, readable by \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}.
}
\description{
Takes a character vector of sequences (which are allowed to be empty \code{""} to
act as a spacing line) and rasterises it into a dataframe that ggplot can read.
}
\examples{
create_image_data(c("ATCG", "", "GGCGGC", ""))

}
